/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.api.SimpleConfigProxy;
import carbonconfiglib.config.ConfigSettings;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public final class PerWorldProxy
implements IConfigProxy {
    public static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    public static final IConfigProxy INSTANCE = new PerWorldProxy(FMLPaths.GAMEDIR.get().resolve("multiplayerconfigs"), FMLPaths.GAMEDIR.get().resolve("defaultconfigs"), FMLPaths.GAMEDIR.get().resolve("saves"));
    Path baseClientPath;
    Path baseServerPath;
    Path saveFolders;

    private PerWorldProxy(Path baseClientPath, Path baseServerPath, Path saveFolders) {
        this.baseClientPath = baseClientPath;
        this.baseServerPath = baseServerPath;
        this.saveFolders = saveFolders;
    }

    public static boolean isProxy(IConfigProxy proxy) {
        return proxy instanceof PerWorldProxy;
    }

    public static ConfigSettings perWorld() {
        return ConfigSettings.withFolderProxy(INSTANCE).withType(ConfigType.SERVER);
    }

    @Override
    public Path getBasePaths(Path relativeFile) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Path path = server.getWorldPath(SERVERCONFIG);
            if (Files.exists(path.resolve(relativeFile), new LinkOption[0])) {
                return path;
            }
        } else if (FMLEnvironment.dist.isClient() && CarbonConfig.NETWORK.isInWorld()) {
            return this.baseClientPath;
        }
        return this.baseServerPath;
    }

    @Override
    public List<? extends IConfigProxy.IPotentialTarget> getPotentialConfigs() {
        if (FMLEnvironment.dist.isClient()) {
            return this.getLevels();
        }
        return Collections.singletonList(new SimpleConfigProxy.SimpleTarget(ServerLifecycleHooks.getCurrentServer().getWorldPath(SERVERCONFIG), "server"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private List<IConfigProxy.IPotentialTarget> getLevels() {
        LevelStorageSource storage = Minecraft.getInstance().getLevelSource();
        ObjectArrayList folders = new ObjectArrayList();
        if (Files.exists(this.baseServerPath, new LinkOption[0])) {
            folders.add(new SimpleConfigProxy.SimpleTarget(this.baseServerPath, "Default Config"));
        }
        for (LevelSummary sum : (List)storage.loadLevelSummaries(storage.findLevelCandidates()).join()) {
            try {
                LevelStorageSource.LevelStorageAccess access = Minecraft.getInstance().getLevelSource().createAccess(sum.getLevelId());
                try {
                    Path path = access.getLevelPath(SERVERCONFIG);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    folders.add(new WorldTarget(sum, access.getLevelPath(LevelResource.ROOT), path));
                }
                finally {
                    if (access == null) continue;
                    access.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return folders;
    }

    @Override
    public boolean isDynamicProxy() {
        return true;
    }

    public static class WorldTarget
    implements IConfigProxy.IPotentialTarget {
        LevelSummary summary;
        Path worldFile;
        Path folder;

        public WorldTarget(LevelSummary summary, Path worldFile, Path folder) {
            this.summary = summary;
            this.worldFile = worldFile;
            this.folder = folder;
        }

        @Override
        public Path getFolder() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.summary.getLevelName();
        }

        public Path getWorldFile() {
            return this.worldFile;
        }

        public LevelSummary getSummary() {
            return this.summary;
        }
    }
}

