/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.plugins.jei.configs;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.utils.ParseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import mezz.jei.api.runtime.config.IJeiConfigListValueSerializer;
import mezz.jei.api.runtime.config.IJeiConfigValue;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;

public class JEIHelpers {
    public static <T> boolean isDefault(IJeiConfigValue<T> entry) {
        return Objects.equals(entry.getDefaultValue(), entry.getValue());
    }

    public static <T> void setDefault(IJeiConfigValue<T> entry) {
        if (JEIHelpers.isDefault(entry)) {
            return;
        }
        entry.set(entry.getDefaultValue());
    }

    public static <T> String getValue(IJeiConfigValue<T> entry) {
        return entry.getSerializer().serialize(entry.getValue());
    }

    public static <T> String getDefault(IJeiConfigValue<T> entry) {
        return entry.getSerializer().serialize(entry.getDefaultValue());
    }

    public static <T> List<String> getArrayValue(IJeiConfigValue<?> entry) {
        return JEIHelpers.getValueArray(entry);
    }

    public static <T> List<String> getArrayDefault(IJeiConfigValue<?> entry) {
        return JEIHelpers.getDefaultArray(entry);
    }

    public static <T> List<String> getValueArray(IJeiConfigValue<List<T>> entry) {
        IJeiConfigValueSerializer serializer = ((IJeiConfigListValueSerializer)entry.getSerializer()).getListValueSerializer();
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : (List)entry.getValue()) {
            result.add(serializer.serialize(value));
        }
        return result;
    }

    public static <T> List<String> getDefaultArray(IJeiConfigValue<List<T>> entry) {
        IJeiConfigValueSerializer serializer = ((IJeiConfigListValueSerializer)entry.getSerializer()).getListValueSerializer();
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : (List)entry.getDefaultValue()) {
            result.add(serializer.serialize(value));
        }
        return result;
    }

    public static <T> void save(List<String> input, IJeiConfigValue<List<T>> entry) {
        IJeiConfigValueSerializer serializer = ((IJeiConfigListValueSerializer)entry.getSerializer()).getListValueSerializer();
        ObjectArrayList result = new ObjectArrayList();
        for (String value : input) {
            JEIHelpers.parseValue(value, serializer, ((List)result)::add);
        }
        entry.set((Object)result);
    }

    public static <T> void parseValue(String input, IJeiConfigValueSerializer<T> serializer, Consumer<T> result) {
        IJeiConfigValueSerializer.IDeserializeResult dataResult = serializer.deserialize(input);
        Optional data = dataResult.getResult();
        if (data.isPresent() && serializer.isValid(data.get())) {
            result.accept(data.get());
        }
    }

    public static <T> ParseResult<T> parse(String input, IJeiConfigValueSerializer<T> serializer) {
        IJeiConfigValueSerializer.IDeserializeResult result = serializer.deserialize(input);
        Optional data = result.getResult();
        if (data.isEmpty()) {
            return ParseResult.error(NoSuchElementException::new, String.join((CharSequence)"\n", result.getErrors()));
        }
        if (serializer.isValid(data.get())) {
            return ParseResult.error(input, "Not a Valid Input");
        }
        return ParseResult.success(data.get());
    }

    public static <T> List<ISuggestionProvider.Suggestion> getSuggestions(IJeiConfigValueSerializer<T> serializer) {
        Optional result = serializer.getAllValidValues();
        if (result.isEmpty()) {
            return ObjectLists.empty();
        }
        ObjectArrayList suggestions = new ObjectArrayList();
        for (Object type : (Collection)result.get()) {
            suggestions.add(ISuggestionProvider.Suggestion.value(serializer.serialize(type)));
        }
        return suggestions;
    }
}

