/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import codechicken.lib.render.CCRenderEventHandler;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer>
implements BackgroundRender {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static final List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private Supplier<Float> rotationSpeed = () -> Float.valueOf(1.0f);
    private Supplier<Float> lockedRotation = () -> Float.valueOf(0.0f);
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private Supplier<Boolean> rotationLocked = () -> false;
    private Supplier<Boolean> trackMouse = () -> false;
    private Supplier<Boolean> drawName = () -> false;
    public boolean force2dSize = false;

    public GuiEntityRenderer(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            this.invalidEntity = true;
            return this;
        }
        this.entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        this.invalidEntity = invalidEntities.contains(this.entityName);
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            EntityType type = BuiltInRegistries.ENTITY_TYPE.getOptional(entity).orElse(null);
            return type == null ? null : type.create((Level)this.mc().level);
        });
        boolean bl = this.invalidEntity = this.entity == null;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = () -> Float.valueOf(rotationSpeed);
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(Supplier<Float> rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed.get().floatValue();
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = () -> Float.valueOf(lockedRotation);
        return this;
    }

    public GuiEntityRenderer setLockedRotation(Supplier<Float> lockedRotation) {
        this.lockedRotation = lockedRotation;
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation.get().floatValue();
    }

    public GuiEntityRenderer setRotationLocked(boolean rotationLocked) {
        this.rotationLocked = () -> rotationLocked;
        return this;
    }

    public GuiEntityRenderer setRotationLocked(Supplier<Boolean> rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public boolean isRotationLocked() {
        return this.rotationLocked.get();
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = () -> trackMouse;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(Supplier<Boolean> trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public boolean isTrackMouse() {
        return this.trackMouse.get();
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = () -> drawName;
        return this;
    }

    public GuiEntityRenderer setDrawName(Supplier<Boolean> drawName) {
        this.drawName = drawName;
        return this;
    }

    public boolean isDrawName() {
        return this.drawName.get();
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public double getBackgroundDepth() {
        Rectangle rect = this.getRectangle();
        if (this.invalidEntity || this.entity == null) {
            return 0.01;
        }
        float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.getBbHeight(), rect.width() / (double)this.entity.getBbWidth()) : rect.height() / (double)this.entity.getBbHeight());
        if (Float.isInfinite(scale)) {
            scale = 1.0f;
        }
        return scale * 2.0f;
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.invalidEntity) {
            return;
        }
        try {
            if (this.entity != null) {
                Rectangle rect = this.getRectangle();
                float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.getBbHeight(), rect.width() / (double)this.entity.getBbWidth()) : rect.height() / (double)this.entity.getBbHeight());
                float xPos = (float)(rect.x() + rect.width() / 2.0);
                float yPos = (float)(this.yMin() + this.ySize() / 2.0 + rect.height() / 2.0);
                float rotation = this.rotationLocked.get() != false ? this.lockedRotation.get().floatValue() : ((float)CCRenderEventHandler.renderTime + partialTicks) * this.rotationSpeed.get().floatValue();
                Entity entity = this.entity;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    int eyeOffset = (int)(this.entity.getEyeHeight() * scale);
                    if (this.trackMouse.get().booleanValue()) {
                        GuiEntityRenderer.renderEntityInInventoryFollowsMouse(render, xPos, yPos, scale, this.force2dSize, xPos - (float)mouseX, yPos - (float)mouseY - (float)eyeOffset, living);
                    } else {
                        GuiEntityRenderer.renderEntityInInventoryWithRotation(render, xPos, yPos, scale, this.force2dSize, rotation, living);
                    }
                } else {
                    Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
                    Quaternionf quaternionf1 = Axis.YP.rotationDegrees(rotation);
                    quaternionf.mul((Quaternionfc)quaternionf1);
                    GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, this.force2dSize, quaternionf, quaternionf1, this.entity);
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LOGGER.error("Failed to render entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LOGGER.error("Entity: " + String.valueOf(this.entity), e);
        }
    }

    public static void renderEntityInInventoryFollowsMouse(GuiRender render, double pX, double pY, double pScale, float offsetX, float offsetY, LivingEntity pEntity) {
        GuiEntityRenderer.renderEntityInInventoryFollowsMouse(render, pX, pY, pScale, false, offsetX, offsetY, pEntity);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiRender render, double pX, double pY, double pScale, boolean flat, float offsetX, float offsetY, LivingEntity pEntity) {
        float xAngle = (float)Math.atan(offsetX / 40.0f);
        float yAngle = (float)Math.atan(offsetY / 40.0f);
        GuiEntityRenderer.renderEntityInInventoryFollowsAngle(render, pX, pY, pScale, flat, xAngle, yAngle, pEntity);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiRender render, double pX, double pY, double pScale, float angleX, float angleY, LivingEntity pEntity) {
        GuiEntityRenderer.renderEntityInInventoryFollowsAngle(render, pX, pY, pScale, false, angleX, angleY, pEntity);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiRender render, double pX, double pY, double pScale, boolean flat, float angleX, float angleY, LivingEntity pEntity) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(angleY * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = pEntity.yBodyRot;
        float f3 = pEntity.getYRot();
        float f4 = pEntity.getXRot();
        float f5 = pEntity.yHeadRotO;
        float f6 = pEntity.yHeadRot;
        pEntity.yBodyRot = 180.0f + angleX * 20.0f;
        pEntity.setYRot(180.0f + angleX * 40.0f);
        pEntity.setXRot(-angleY * 20.0f);
        pEntity.yHeadRot = pEntity.getYRot();
        pEntity.yHeadRotO = pEntity.getYRot();
        GuiEntityRenderer.renderEntityInInventory(render, pX, pY, pScale, flat, quaternionf, quaternionf1, (Entity)pEntity);
        pEntity.yBodyRot = f2;
        pEntity.setYRot(f3);
        pEntity.setXRot(f4);
        pEntity.yHeadRotO = f5;
        pEntity.yHeadRot = f6;
    }

    public static void renderEntityInInventoryWithRotation(GuiRender render, double xPos, double yPos, double scale, double rotation, LivingEntity living) {
        GuiEntityRenderer.renderEntityInInventoryWithRotation(render, xPos, yPos, scale, false, rotation, living);
    }

    public static void renderEntityInInventoryWithRotation(GuiRender render, double xPos, double yPos, double scale, boolean flat, double rotation, LivingEntity living) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = Axis.YP.rotationDegrees((float)rotation);
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = living.yBodyRot;
        float f3 = living.getYRot();
        float f4 = living.getXRot();
        float f5 = living.yHeadRotO;
        float f6 = living.yHeadRot;
        living.yBodyRot = 180.0f;
        living.setYRot(180.0f);
        living.setXRot(0.0f);
        living.yHeadRot = living.getYRot();
        living.yHeadRotO = living.getYRot();
        GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, flat, quaternionf, quaternionf1, (Entity)living);
        living.yBodyRot = f2;
        living.setYRot(f3);
        living.setXRot(f4);
        living.yHeadRotO = f5;
        living.yHeadRot = f6;
    }

    public static void renderEntityInInventory(GuiRender render, double pX, double pY, double pScale, Quaternionf quat, @Nullable Quaternionf pCameraOrientation, Entity pEntity) {
        GuiEntityRenderer.renderEntityInInventory(render, pX, pY, pScale, false, quat, pCameraOrientation, pEntity);
    }

    public static void renderEntityInInventory(GuiRender render, double pX, double pY, double pScale, boolean flat, Quaternionf quat, @Nullable Quaternionf pCameraOrientation, Entity pEntity) {
        render.pose().pushPose();
        render.pose().translate(pX, pY, 50.0);
        render.pose().scale((float)pScale, (float)pScale, flat ? -1.0f : (float)(-pScale));
        render.pose().mulPose(quat);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (pCameraOrientation != null) {
            pCameraOrientation.conjugate();
            entityrenderdispatcher.overrideCameraOrientation(pCameraOrientation);
        }
        entityrenderdispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render(pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, render.pose(), (MultiBufferSource)render.buffers(), 0xF000F0));
        render.flush();
        entityrenderdispatcher.setRenderShadow(true);
        render.pose().popPose();
        Lighting.setupFor3DItems();
    }
}

