/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Int2ObjectMap<ICustomPacketHandler.IServerPacketHandler> handlers = new Int2ObjectArrayMap();

    protected void addHandler(int id, ICustomPacketHandler.IServerPacketHandler handler) {
        if (handlers.containsKey(id)) {
            throw new IllegalArgumentException("Handler already registered for ID: " + id);
        }
        handlers.put(id, (Object)handler);
    }

    @Override
    public void handlePacket(PacketCustom packet, ServerPlayer sender) {
        ICustomPacketHandler.IServerPacketHandler h = (ICustomPacketHandler.IServerPacketHandler)handlers.get(packet.getType());
        if (h != null) {
            h.handlePacket(packet, sender);
        } else {
            LOGGER.warn("Received unknown packet on channel '{}' with descriptor '{}'.", (Object)packet.getChannel(), (Object)packet.getType());
        }
    }
}

