/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.registry;

import java.util.List;
import java.util.function.Supplier;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.items.stick.ItemStickBasic;
import mrbysco.constructionstick.items.template.ItemAngelTemplate;
import mrbysco.constructionstick.items.template.ItemBatteryTemplate;
import mrbysco.constructionstick.items.template.ItemDestructionTemplate;
import mrbysco.constructionstick.items.template.ItemReplacementTemplate;
import mrbysco.constructionstick.items.template.ItemUnbreakableTemplate;
import mrbysco.constructionstick.items.template.ItemUpgradeTemplate;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="constructionstick", bus=EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"constructionstick");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"constructionstick");
    public static final DeferredItem<ItemStick> STICK_WOODEN = ITEMS.register("wooden_stick", () -> new ItemStickBasic(ModItems.propStick(), (Tier)Tiers.WOOD));
    public static final DeferredItem<ItemStick> STICK_COPPER = ITEMS.register("copper_stick", () -> new ItemStickBasic(ModItems.propStick(), (Tier)Tiers.STONE));
    public static final DeferredItem<ItemStick> STICK_IRON = ITEMS.register("iron_stick", () -> new ItemStickBasic(ModItems.propStick(), (Tier)Tiers.IRON));
    public static final DeferredItem<ItemStick> STICK_DIAMOND = ITEMS.register("diamond_stick", () -> new ItemStickBasic(ModItems.propStick(), (Tier)Tiers.DIAMOND));
    public static final DeferredItem<ItemStick> STICK_NETHERITE = ITEMS.register("netherite_stick", () -> new ItemStickBasic(ModItems.propStick().fireResistant(), (Tier)Tiers.NETHERITE));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_ANGEL = ITEMS.register("template_angel", () -> new ItemAngelTemplate(ModItems.propUpgrade()));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_DESTRUCTION = ITEMS.register("template_destruction", () -> new ItemDestructionTemplate(ModItems.propUpgrade()));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_REPLACEMENT = ITEMS.register("template_replacement", () -> new ItemReplacementTemplate(ModItems.propUpgrade()));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_UNBREAKABLE = ITEMS.register("template_unbreakable", () -> new ItemUnbreakableTemplate(ModItems.propUpgrade()));
    public static final DeferredItem<ItemUpgradeTemplate> TEMPLATE_BATTERY = ITEMS.register("template_battery", () -> new ItemBatteryTemplate(ModItems.propUpgrade()));
    public static final List<DeferredItem<ItemStick>> STICKS = List.of(STICK_WOODEN, STICK_COPPER, STICK_IRON, STICK_DIAMOND, STICK_NETHERITE);
    public static final List<DeferredItem<ItemUpgradeTemplate>> TEMPLATES = List.of(TEMPLATE_ANGEL, TEMPLATE_DESTRUCTION, TEMPLATE_REPLACEMENT, TEMPLATE_UNBREAKABLE, TEMPLATE_BATTERY);
    public static final Supplier<CreativeModeTab> CONSTRUCTION_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)STICK_WOODEN.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.constructionstick.tab")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());

    public static Item.Properties propStick() {
        return new Item.Properties();
    }

    private static Item.Properties propUpgrade() {
        return new Item.Properties().stacksTo(1);
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        block3: {
            block2: {
                if (event.getTabKey() != CreativeModeTabs.TOOLS_AND_UTILITIES) break block2;
                for (DeferredItem<ItemStick> itemSupplier : STICKS) {
                    event.accept(itemSupplier);
                }
                break block3;
            }
            if (event.getTabKey() != CreativeModeTabs.INGREDIENTS) break block3;
            for (DeferredItem<ItemUpgradeTemplate> itemSupplier : TEMPLATES) {
                event.accept(itemSupplier);
            }
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder deferredHolder : STICKS) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> {
                ConstructionConfig.StickProperties properties = ConstructionConfig.getStickProperties((Item)holder.get());
                return new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)ModDataComponents.BATTERY.get(), properties.getBatteryStorage(), 200, properties.getBatteryUsage(), (ItemStack)stack){
                    final /* synthetic */ ItemStack val$stack;
                    {
                        this.val$stack = itemStack;
                        super(arg0, arg1, arg2, arg3, arg4);
                    }

                    public boolean canExtract() {
                        return this.val$stack.has(ModDataComponents.BATTERY_ENABLED) && super.canExtract();
                    }

                    public boolean canReceive() {
                        return this.val$stack.has(ModDataComponents.BATTERY_ENABLED) && super.canReceive();
                    }
                };
            }, new ItemLike[]{(ItemLike)deferredHolder.get()});
        }
    }
}

