/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui;

import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.CustomButton;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.service.CosmeticsApi;

public class CosmeticsClaimModal
extends ContainerWidget {
    public CosmeticsClaimModal(int x, int y, int width, int height) {
        super(x, y, width, height);
        LinearLayout layout = LinearLayout.vertical().spacing(5);
        Runnable centerLayout = () -> layout.visitChildren(element -> element.setX(x + (width - element.getWidth()) / 2));
        layout.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.literal((String)"Enter the code you received,\ninto the text box below, to claim your cosmetic.\n"), Minecraft.getInstance().font).setMaxWidth(width).setCentered(true));
        MultiLineTextWidget label = (MultiLineTextWidget)layout.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.literal((String)"\n"), Minecraft.getInstance().font).setMaxWidth(width).setCentered(true));
        AtomicReference<String> input = new AtomicReference<String>("");
        layout.addChild((LayoutElement)new StringOptionWidget(input::get, s -> {
            input.set((String)s);
            return true;
        }, false));
        layout.addChild((LayoutElement)new CustomButton(76, 12, (Component)Component.literal((String)"Claim"), () -> this.claimReward((String)input.get(), message -> {
            label.setMessage((Component)Component.literal((String)message));
            centerLayout.run();
        })));
        layout.setPosition(x, y);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        centerLayout.run();
    }

    public void claimReward(String code, Consumer<String> messageSetter) {
        CosmeticsApi.claimReward(code).thenAcceptAsync(status -> {
            switch (status) {
                case OK: {
                    Minecraft.getInstance().tell(() -> {
                        Screen screen = Minecraft.getInstance().screen;
                        if (screen != null) {
                            screen.onClose();
                        }
                    });
                    break;
                }
                case FORBIDDEN: {
                    messageSetter.accept("\u00a7cCode claimed already!");
                    break;
                }
                case NOT_FOUND: {
                    messageSetter.accept("\u00a7cInvalid code!");
                    break;
                }
                case UNKOWN_ERROR: {
                    messageSetter.accept("\u00a7cClient error!");
                    break;
                }
                default: {
                    messageSetter.accept("\u00a7cUnknown error!");
                }
            }
        });
    }
}

