/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui;

import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigScreen;
import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.CustomButton;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.service.CosmeticsApi;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui.CosmeticsModal;

public class LoginModal
extends ContainerWidget {
    private final StringWidget label;

    public LoginModal(int x, int y, int width, int height) {
        super(x, y, width, height);
        LinearLayout layout = LinearLayout.vertical().spacing(5);
        this.label = ((StringWidget)layout.addChild((LayoutElement)new StringWidget(0, 12, (Component)Component.literal((String)"Login"), Minecraft.getInstance().font))).alignCenter();
        AtomicBoolean loggingIn = new AtomicBoolean(false);
        layout.addChild((LayoutElement)new CustomButton(Math.min(width, 100), 12, (Component)Component.literal((String)"Login"), () -> {
            if (loggingIn.get()) {
                return;
            }
            loggingIn.set(true);
            this.label.setMessage((Component)Component.literal((String)"Logging in..."));
            CosmeticsApi.login().thenAcceptAsync(status -> {
                switch (status) {
                    case OK: {
                        this.label.setMessage((Component)Component.literal((String)"Getting available cosmetics..."));
                        CosmeticsApi.getCosmetics().thenAcceptAsync(cosmeticsStatus -> {
                            switch (cosmeticsStatus) {
                                case OK: {
                                    Minecraft.getInstance().tell(() -> {
                                        Screen screen = Minecraft.getInstance().screen;
                                        if (screen != null) {
                                            screen.onClose();
                                            ResourcefulConfigScreen.openModal((Component)Component.empty(), CosmeticsModal::new);
                                        }
                                    });
                                    break;
                                }
                                case UNAUTHORIZED: {
                                    this.label.setMessage((Component)Component.literal((String)"Failed to get cosmetics, try again later."));
                                    break;
                                }
                                case INTERNAL_SERVER_ERROR: {
                                    this.label.setMessage((Component)Component.literal((String)"Error occurred on server side while getting cosmetics."));
                                    break;
                                }
                                case UNKOWN_ERROR: {
                                    this.label.setMessage((Component)Component.literal((String)"Unknown error occurred while getting cosmetics."));
                                }
                            }
                        });
                        break;
                    }
                    case UNAUTHORIZED: {
                        this.label.setMessage((Component)Component.literal((String)"Failed to login, check if you are logged in to Minecraft."));
                        break;
                    }
                    case INTERNAL_SERVER_ERROR: {
                        this.label.setMessage((Component)Component.literal((String)"Error occurred on server side while logging in."));
                        break;
                    }
                    case UNKOWN_ERROR: {
                        this.label.setMessage((Component)Component.literal((String)"Unknown error occurred while logging in."));
                    }
                }
            });
        }));
        layout.setPosition(x, y);
        layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)layout, (int)x, (int)y, (int)width, (int)height);
        this.label.setWidth(width);
        this.label.setX(x);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }
}

