/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.items.components.DimStorageComponents;
import edivad.dimstorage.items.components.FrequencyTabletComponent;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.menu.DimTabletMenu;
import edivad.dimstorage.setup.Config;
import edivad.dimstorage.storage.DimChestStorage;
import edivad.dimstorage.tools.InventoryUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class DimTablet
extends Item
implements MenuProvider {
    public DimTablet(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        if (!player.isCrouching()) {
            return InteractionResult.PASS;
        }
        ItemStack device = player.getItemInHand(context.getHand());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityDimChest) {
            BlockEntityDimChest dimChest = (BlockEntityDimChest)blockEntity;
            if (dimChest.canAccess(player)) {
                device.set(DimStorageComponents.FREQUENCY_TABLET, (Object)new FrequencyTabletComponent(dimChest.getFrequency(), true, false));
                player.displayClientMessage((Component)Component.literal((String)"Linked to chest").withStyle(ChatFormatting.GREEN), false);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.literal((String)"Access Denied!").withStyle(ChatFormatting.RED), false);
            return InteractionResult.PASS;
        }
        FrequencyTabletComponent frequencyComponent = (FrequencyTabletComponent)device.get(DimStorageComponents.FREQUENCY_TABLET);
        if (frequencyComponent != null) {
            FrequencyTabletComponent updatedFrequency = new FrequencyTabletComponent(frequencyComponent.frequency(), frequencyComponent.bound(), !frequencyComponent.autocollect());
            device.set(DimStorageComponents.FREQUENCY_TABLET, (Object)updatedFrequency);
            if (updatedFrequency.autocollect()) {
                player.displayClientMessage((Component)Component.literal((String)"Enabled autocollect").withStyle(ChatFormatting.GREEN), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"Disabled autocollect").withStyle(ChatFormatting.RED), false);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            return super.use(level, player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        FrequencyTabletComponent frequencyComponent = (FrequencyTabletComponent)stack.get(DimStorageComponents.FREQUENCY_TABLET);
        if (frequencyComponent == null || !frequencyComponent.bound()) {
            if (level.isClientSide()) {
                player.displayClientMessage((Component)Component.literal((String)"Dimensional Tablet not connected to any DimChest").withStyle(ChatFormatting.RED), false);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND && frequencyComponent.frequency().canAccess(player)) {
                serverPlayer.openMenu((MenuProvider)this);
            }
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (level.isClientSide) {
            return;
        }
        FrequencyTabletComponent frequencyComponent = (FrequencyTabletComponent)stack.get(DimStorageComponents.FREQUENCY_TABLET);
        if (frequencyComponent == null) {
            return;
        }
        if (frequencyComponent.autocollect() && frequencyComponent.bound() && entity instanceof Player) {
            Player player = (Player)entity;
            Frequency f = frequencyComponent.frequency();
            InvWrapper chestInventory = new InvWrapper((Container)this.getStorage(level, f));
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                Item item = player.getInventory().getItem(i).getItem();
                if (!Config.DimTablet.containItem(item)) continue;
                InventoryUtils.mergeItemStack(player.getInventory().getItem(i), 0, this.getStorage(level, f).getContainerSize(), chestInventory);
            }
        }
    }

    private DimChestStorage getStorage(Level level, Frequency frequency) {
        return (DimChestStorage)DimStorageManager.instance(level).getStorage((HolderLookup.Provider)level.registryAccess(), frequency, "item");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        MutableComponent ADVICE_TO_LINK = Component.translatable((String)"message.dimstorage.press").withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.literal((String)"Shift").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.AQUA})).append((Component)Component.literal((String)" + ").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)"message.dimstorage.bind_dimchest").withStyle(ChatFormatting.GRAY));
        FrequencyTabletComponent frequencyComponent = (FrequencyTabletComponent)stack.get(DimStorageComponents.FREQUENCY_TABLET);
        if (frequencyComponent == null || !frequencyComponent.bound()) {
            tooltip.add((Component)ADVICE_TO_LINK);
            return;
        }
        frequencyComponent.addToTooltip(context, tooltip::add, tooltipFlag);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new DimTabletMenu(id, inventory, player.level());
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }
}

