/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleData;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.StructureBlock;
import com.brandon3055.draconicevolution.blocks.machines.EnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TileEnergyCoreStabilizer
extends TileBCore
implements IInteractTile,
MultiBlockController {
    public final ManagedPos coreOffset = (ManagedPos)this.register((IManagedData)new ManagedPos("core_offset", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isCoreActive = (ManagedBool)this.register((IManagedData)new ManagedBool("is_core_active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isValidMultiBlock = (ManagedBool)this.register((IManagedData)new ManagedBool("is_valid_multi_block", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction.Axis> multiBlockAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("multi_block_axis", (Enum)Direction.Axis.Y, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction> coreDirection = (ManagedEnum)this.register((IManagedData)new ManagedEnum("core_direction", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    private boolean moveCheckComplete = false;

    public TileEnergyCoreStabilizer(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CORE_STABILIZER.get(), pos, state);
    }

    @Override
    public InteractionResult handleRemoteClick(Player player, BlockHitResult hit) {
        if (this.level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        TileEnergyCore core = this.getCore();
        if (core == null) {
            core = this.findCore();
        }
        if (core != null) {
            core.handleRemoteClick(player, hit);
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"msg.draconicevolution.energy_core.core_not_found").withStyle(ChatFormatting.DARK_RED));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        return this.handleRemoteClick(player, hit);
    }

    public void onPlaced() {
        if (this.level.isClientSide || this.checkAndFormMultiBlock()) {
            return;
        }
        for (BlockPos offset : FacingUtils.AROUND_ALL) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)offset));
            if (!(blockEntity instanceof TileEnergyCoreStabilizer) || !((TileEnergyCoreStabilizer)blockEntity).checkAndFormMultiBlock()) continue;
            return;
        }
    }

    private boolean checkAndFormMultiBlock() {
        TileEnergyCore core = this.getCore();
        if (core != null && core.active.get()) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (!this.checkAxisValid(axis)) continue;
            this.buildMultiBlock(axis);
            return true;
        }
        return false;
    }

    private boolean checkAxisValid(Direction.Axis axis) {
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            if (this.isAvailable(this.worldPosition.offset((Vec3i)offset))) continue;
            return false;
        }
        return true;
    }

    private boolean isAvailable(BlockPos pos) {
        BlockEntity tile = this.level.getBlockEntity(pos);
        if (this.isValidMultiBlock.get()) {
            return tile instanceof TileStructureBlock && ((TileStructureBlock)tile).getController() == this;
        }
        return tile instanceof TileEnergyCoreStabilizer && (((TileEnergyCoreStabilizer)tile).getCore() == null || !((TileEnergyCoreStabilizer)tile).getCore().active.get());
    }

    private void buildMultiBlock(Direction.Axis axis) {
        this.coreOffset.set(null);
        StructureBlock.buildingLock = true;
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            this.level.setBlockAndUpdate(this.worldPosition.offset((Vec3i)offset), ((StructureBlock)((Object)DEContent.STRUCTURE_BLOCK.get())).defaultBlockState());
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)offset));
            if (!(blockEntity instanceof TileStructureBlock)) continue;
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            tile.blockName.set(DEContent.ENERGY_CORE_STABILIZER.getId());
            tile.setController(this);
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(true)));
        this.isValidMultiBlock.set(true);
        this.multiBlockAxis.set((Enum)axis);
        StructureBlock.buildingLock = false;
    }

    @Override
    public boolean validateStructure() {
        TileEnergyCore core;
        if (this.checkAxisValid((Direction.Axis)this.multiBlockAxis.get())) {
            return true;
        }
        this.revertStructure();
        if (this.isCoreActive.get() && ((core = this.getCore()) == null || !core.active.get())) {
            this.isCoreActive.set(false);
        }
        return false;
    }

    @Override
    public boolean isStructureValid() {
        return this.isValidMultiBlock.get();
    }

    public boolean isSuitableForCore(int coreTier, TileEnergyCore core) {
        if (coreTier < 5 && !this.isValidMultiBlock.get()) {
            return true;
        }
        if (coreTier >= 5 && this.isValidMultiBlock.get()) {
            BlockPos offset = this.worldPosition.subtract((Vec3i)core.getBlockPos());
            Direction direction = Direction.getNearest((float)offset.getX(), (float)offset.getY(), (float)offset.getZ()).getOpposite();
            return direction.getAxis() == this.multiBlockAxis.get();
        }
        return false;
    }

    public void revertStructure() {
        if (this.level.getBlockState(this.worldPosition).is((Block)DEContent.ENERGY_CORE_STABILIZER.get())) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(false)));
        }
        this.isValidMultiBlock.set(false);
        if (this.getCore() != null) {
            this.getCore().deactivateCore();
        }
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)((Direction.Axis)this.multiBlockAxis.get()))) {
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)offset));
            if (!(tile instanceof TileStructureBlock)) continue;
            ((TileStructureBlock)tile).revert();
        }
    }

    public TileEnergyCore findCore() {
        if (this.getCore() != null) {
            return this.getCore();
        }
        for (Direction facing : Direction.values()) {
            for (int i = 0; i < 16; ++i) {
                BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset(facing.getStepX() * i, facing.getStepY() * i, facing.getStepZ() * i));
                if (!(tile instanceof TileEnergyCore)) continue;
                TileEnergyCore core = (TileEnergyCore)tile;
                core.validateStructure();
                if (core.active.get()) continue;
                return core;
            }
        }
        return null;
    }

    public TileEnergyCore getCore() {
        BlockPos corePos = this.getCorePos();
        if (corePos != null) {
            BlockEntity tile = this.level.getBlockEntity(corePos);
            if (tile instanceof TileEnergyCore) {
                return (TileEnergyCore)tile;
            }
            this.coreOffset.set(null);
        }
        return null;
    }

    @Nullable
    private BlockPos getCorePos() {
        return this.coreOffset.get() == null ? null : this.worldPosition.subtract((Vec3i)Objects.requireNonNull(this.coreOffset.get()));
    }

    public void setCore(@Nullable TileEnergyCore core) {
        if (core == null) {
            this.coreOffset.set(null);
            return;
        }
        BlockPos offset = this.worldPosition.subtract((Vec3i)core.getBlockPos());
        this.coreOffset.set(offset);
        this.coreDirection.set((Enum)Direction.getNearest((float)offset.getX(), (float)offset.getY(), (float)offset.getZ()).getOpposite());
    }

    @Override
    public VoxelShape getShapeForPart(BlockPos pos, CollisionContext context) {
        BlockState stabState = this.level.getBlockState(this.worldPosition);
        if (stabState.is((Block)DEContent.ENERGY_CORE_STABILIZER.get())) {
            BlockPos offset = this.worldPosition.subtract((Vec3i)pos);
            return stabState.getShape((BlockGetter)this.level, this.worldPosition, context).move((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
        }
        return Shapes.block();
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide && this.coreOffset.get() != null && this.isCoreActive.get()) {
            this.rotation = TimeKeeper.getClientTick();
            this.updateVisual();
            if (this.isValidMultiBlock.get()) {
                this.updateVisual();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateVisual() {
        Vec3D spawn = new Vec3D(this.worldPosition);
        spawn.add(0.5, 0.5, 0.5);
        double rand = (double)this.level.random.nextInt(100) / 12.0;
        double randOffset = rand * (Math.PI * 2);
        double offsetX = Math.sin((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        double offsetY = Math.cos((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        if (!this.isValidMultiBlock.get() || this.level.random.nextBoolean()) {
            double inset;
            double d = this.isValidMultiBlock.get() ? 1.1 : 0.25;
            double d2 = inset = this.isValidMultiBlock.get() ? 1.0 : 0.0;
            if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.Z) {
                spawn.add(offsetX * d, offsetY * d, (this.level.random.nextBoolean() ? -0.38 : 0.38) * inset);
            } else if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.Y) {
                spawn.add(offsetX * d, (this.level.random.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d);
            } else if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.X) {
                spawn.add((this.level.random.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d, offsetX * d);
            }
            Vector3 target = Vector3.fromBlockPosCenter((BlockPos)this.worldPosition).subtract((Vec3i)this.coreOffset.get());
            this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY_CORE.get(), new Integer[]{1, (int)(randOffset * 100.0), this.isValidMultiBlock.get() ? 1 : 0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        } else {
            if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.Z) {
                spawn.add(offsetX * 1.2, offsetY * 1.2, this.level.random.nextBoolean() ? -0.38 : 0.38);
            } else if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.Y) {
                spawn.add(offsetX * 1.2, this.level.random.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2);
            } else if (((Direction)this.coreDirection.get()).getAxis() == Direction.Axis.X) {
                spawn.add(this.level.random.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2, offsetX * 1.2);
            }
            Vector3 target = Vector3.fromBlockPosCenter((BlockPos)this.worldPosition);
            this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY_CORE.get(), new Integer[]{0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        }
    }
}

