/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;

public class ParticlePortal
extends TextureSheetParticle {
    public Vector3 target;
    public Vector3 start;
    public float baseScale;

    public ParticlePortal(ClientLevel worldIn, Vector3 pos, Vector3 target) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.start = pos;
        this.target = target;
        float speed = 0.12f + this.random.nextFloat() * 0.2f;
        this.xd = (target.x - this.start.x) * (double)speed;
        this.yd = (target.y - this.start.y) * (double)speed;
        this.zd = (target.z - this.start.z) * (double)speed;
        this.sprite = AtlasTextureHelper.PORTAL_PARTICLE;
        this.lifetime = 120;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        float baseSize = 0.05f + (float)Math.sqrt(Minecraft.getInstance().player.distanceToSqr(pos.x, pos.y, pos.z)) * 0.007f;
        this.baseScale = (baseSize + this.random.nextFloat() * (baseSize * 2.0f)) * 0.1f;
        this.quadSize = 0.0f;
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        return AtlasTextureHelper.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        double distToTarget = MathUtils.distance((Vector3)new Vector3(this.x, this.y, this.z), (Vector3)this.target);
        if (this.age >= this.lifetime || distToTarget < 0.15) {
            this.remove();
            return;
        }
        double startDist = MathUtils.distance((Vector3)this.start, (Vector3)this.target);
        this.quadSize = (float)(distToTarget / startDist) * this.baseScale;
        ++this.age;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(this.xd, this.yd, this.zd);
    }

    protected int getLightColor(float p_189214_1_) {
        return 0xF000F0;
    }
}

