/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class BombardPlayerPhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private int tick;
    private int timeSinceStart;
    private float damageTaken;
    private boolean bombarding = false;
    private Vec3 targetLocation;
    private Player targetPlayer;
    private int minAttackRange = 20;
    private int maxAttackRange = 90;

    public BombardPlayerPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    @Override
    public void serverTick() {
        if (this.targetPlayer == null || !this.isValidTarget((LivingEntity)this.targetPlayer)) {
            this.debug("Aborting bombardment as no target is available. or target is dead.");
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
        } else if (this.timeSinceStart > 0 && this.timeSinceStart >= 160) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            this.debug("Ending bombardment, Timed out");
        } else {
            double distance = this.targetPlayer.distanceTo((Entity)this.guardian);
            this.targetLocation = this.targetPlayer.position();
            if (!this.bombarding) {
                double tRelZ;
                double tRelX = this.targetLocation.x - this.guardian.getX();
                double relTargetAngle = Mth.clamp((double)Mth.wrapDegrees((double)(180.0 - Mth.atan2((double)tRelX, (double)(tRelZ = this.targetLocation.z - this.guardian.getZ())) * 57.2957763671875 - (double)this.guardian.getYRot())), (double)-50.0, (double)50.0);
                boolean bl = this.bombarding = Math.abs(relTargetAngle) < 1.0;
                if (this.bombarding) {
                    this.debug("Bombs Away!");
                }
            } else {
                ++this.timeSinceStart;
            }
            if (distance < (double)this.minAttackRange) {
                this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
                this.debug("Ending bombardment, To close");
            } else if (this.bombarding && distance <= (double)this.maxAttackRange && this.timeSinceStart % 2 == 0) {
                Vec3 vector3d2 = this.guardian.getViewVector(1.0f);
                double headX = this.guardian.dragonPartHead.getX() - vector3d2.x;
                double headY = this.guardian.dragonPartHead.getY(0.5) + 0.5;
                double headZ = this.guardian.dragonPartHead.getZ() - vector3d2.z;
                Vec3 targetPos = this.targetPlayer.position().add(this.targetPlayer.getDeltaMovement().multiply(5.0, 5.0, 5.0));
                targetPos = targetPos.add(this.guardian.getRandom().nextGaussian() * 10.0, this.guardian.getRandom().nextGaussian() * 10.0, this.guardian.getRandom().nextGaussian() * 10.0);
                double targetRelX = targetPos.x - headX;
                double targetRelY = targetPos.y - headY;
                double targetRelZ = targetPos.z - headZ;
                if (!this.guardian.isSilent()) {
                    BCoreNetwork.sendSound((Level)this.guardian.level(), (Entity)this.guardian, (SoundEvent)SoundEvents.ENDER_DRAGON_SHOOT, (SoundSource)SoundSource.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
                }
                GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.level(), (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
                projectile.moveTo(headX, headY, headZ, 0.0f, 0.0f);
                this.guardian.level().addFreshEntity((Entity)projectile);
            }
        }
        if (this.tick > 100) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting charge, Master timed out");
        } else if (this.bombarding && this.timeSinceStart < 20 && this.timeSinceStart % 5 == 0) {
            this.guardian.playSound(SoundEvents.ENDER_DRAGON_GROWL, 20.0f, 0.95f + this.guardian.getRandom().nextFloat() * 0.2f);
        }
        ++this.tick;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceStart = 0;
        this.bombarding = false;
        this.tick = 0;
        this.damageTaken = 0.0f;
    }

    @Override
    public void targetPlayer(Player player) {
        this.targetPlayer = player;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<BombardPlayerPhase> getType() {
        return PhaseType.BOMBARD_PLAYER;
    }

    @Override
    public double getGuardianSpeed() {
        double speed = 1.0;
        if (this.targetPlayer != null) {
            double distance = this.targetPlayer.distanceTo((Entity)this.guardian);
            double sweetSpot = (double)this.minAttackRange + (double)(this.maxAttackRange - this.minAttackRange) / 2.0;
            speed = Mth.clamp((double)((distance - sweetSpot) / 10.0), (double)0.5, (double)3.0);
        }
        return this.bombarding ? speed : 0.5;
    }

    @Override
    public float getYawFactor() {
        return super.getYawFactor() * (float)(this.bombarding ? 2 : 1);
    }

    @Override
    public boolean highVerticalAgility() {
        return false;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        float abortThreshold;
        this.damageTaken += damage;
        float f = abortThreshold = shield > damage ? 512.0f : 128.0f;
        if (this.damageTaken > abortThreshold && !this.bombarding && this.tick > 80) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).prevAttackFailed();
            this.debug("Aborting bombardment, Damage Taken");
        }
        return super.onAttacked(source, damage, shield, effective);
    }
}

