/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomPotionEffect;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.Range;

public class RandomPotionEffect {
    private static float[] CHANCES;
    private static Range[] ROLLS;
    private static WeightedRandomPotionEffect[] EFFECTS;
    private static PotionEffect[][] GUARANTEED_EFFECTS;

    public static void loadJson(ResourceManager resourceManager) {
        CHANCES = new float[5];
        ROLLS = new Range[5];
        EFFECTS = new WeightedRandomPotionEffect[5];
        GUARANTEED_EFFECTS = new PotionEffect[5][];
        try {
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_1.json"), 0);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_2.json"), 1);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_3.json"), 2);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_4.json"), 3);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_5.json"), 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster potion effect files.");
            e.printStackTrace();
        }
    }

    private static void loadFile(ResourceManager resourceManager, ResourceLocation file, int stage) throws IOException {
        Resource resource = (Resource)resourceManager.getResource(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + String.valueOf(file)));
        try {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(resource.open()))).getAsJsonObject();
            if (!object.has("chance")) {
                throw new DatapackLoadException("Missing entry 'chance' in " + String.valueOf(file));
            }
            RandomPotionEffect.CHANCES[stage] = object.get("chance").getAsFloat();
            if (!object.has("rolls")) {
                throw new DatapackLoadException("Missing entry 'rolls' in " + String.valueOf(file));
            }
            JsonObject amount = object.getAsJsonObject("rolls");
            RandomPotionEffect.ROLLS[stage] = new Range(amount.get("min").getAsInt(), amount.get("max").getAsInt());
            if (!object.has("effects")) {
                throw new DatapackLoadException("Missing entry 'effects' in " + String.valueOf(file));
            }
            RandomPotionEffect.EFFECTS[stage] = WeightedRandomPotionEffect.fromJson(object.getAsJsonArray("effects"));
            if (object.has("guaranteed")) {
                JsonArray array = object.getAsJsonArray("guaranteed");
                RandomPotionEffect.GUARANTEED_EFFECTS[stage] = new PotionEffect[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject effect = array.get(i).getAsJsonObject();
                    Range amplifier = effect.has("amplifier") ? new Range(effect.getAsJsonObject("amplifier").get("min").getAsInt(), effect.getAsJsonObject("amplifier").get("max").getAsInt()) : new Range(0, 0);
                    RandomPotionEffect.GUARANTEED_EFFECTS[stage][i] = new PotionEffect((Holder<MobEffect>)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effect.get("effect").getAsString())).orElseThrow()), effect.get("duration").getAsInt(), amplifier);
                }
            }
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {} ", (Object)file);
            e.printStackTrace();
        }
    }

    @Nullable
    public static ListTag createPotionEffects(RandomSource rand, int stage) {
        boolean guaranteed;
        if (stage > 4) {
            stage = 4;
        }
        boolean chance = rand.nextFloat() < CHANCES[stage];
        boolean bl = guaranteed = GUARANTEED_EFFECTS[stage] != null;
        if (chance || guaranteed) {
            int rolls;
            ListTag list = new ListTag();
            if (chance && (rolls = ROLLS[stage].nextInt(rand)) > 0) {
                HashSet<Holder<MobEffect>> effects = new HashSet<Holder<MobEffect>>();
                for (int i = 0; i < rolls; ++i) {
                    WeightedRandomPotionEffect.WeightedEntry weightedEntry = EFFECTS[stage].roll(rand);
                    if (weightedEntry == null || !effects.add(weightedEntry.effect())) continue;
                    list.add((Object)RandomPotionEffect.toNBT(weightedEntry.effect(), weightedEntry.duration(), weightedEntry.amplifier().nextInt(rand)));
                }
            }
            if (guaranteed) {
                for (PotionEffect potionEffect : GUARANTEED_EFFECTS[stage]) {
                    list.add((Object)RandomPotionEffect.toNBT(potionEffect.effect, potionEffect.duration, potionEffect.amplifier.nextInt(rand)));
                }
            }
            return list;
        }
        return null;
    }

    private static Tag toNBT(Holder<MobEffect> effect, int duration, int amplifier) {
        return new MobEffectInstance(effect, duration, amplifier).save();
    }

    private record PotionEffect(Holder<MobEffect> effect, int duration, Range amplifier) {
    }
}

