/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedMagmaBlock
extends MagmaBlock
implements EntityBlock {
    public EnchantedMagmaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedBlockEntity(pos, state);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        Holder<Enchantment> boilingHolder;
        IEnchantable enchantable;
        float damage = 1.0f;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(boilingHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, ModEnchantments.BOILING))) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(boilingHolder);
            damage *= (float)(enchantmentLevel + 1);
        }
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), damage);
        }
        super.stepOn(level, pos, state, entity);
    }

    public Item asItem() {
        return Items.MAGMA_BLOCK;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Holder<Enchantment> blastHolder;
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(blastHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION))) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(blastHolder);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE))) {
            return List.of();
        }
        return super.getDrops(state, params);
    }
}

