/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.google.common.collect.Lists;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.menu.EnchantedBeaconMenu;
import com.mrbysco.enchantableblocks.mixin.BeaconBeamSectionAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import com.mrbysco.enchantableblocks.util.TagHelper;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EnchantedBeaconBlockEntity
extends BeaconBlockEntity
implements IEnchantable {
    protected boolean hideGlint;
    protected ListTag enchantmentTag = null;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    public EnchantedBeaconBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENCHANTED_BEACON_BLOCK_ENTITY.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnchantedBeaconBlockEntity blockEntity) {
        BlockPos blockpos;
        int xPos = pos.getX();
        int yPos = pos.getY();
        int zPos = pos.getZ();
        if (blockEntity.lastCheckY < yPos) {
            blockpos = pos;
            blockEntity.checkingBeamSections = Lists.newArrayList();
            blockEntity.lastCheckY = pos.getY() - 1;
        } else {
            blockpos = new BlockPos(xPos, blockEntity.lastCheckY + 1, zPos);
        }
        BeaconBlockEntity.BeaconBeamSection beamSection = blockEntity.checkingBeamSections.isEmpty() ? null : (BeaconBlockEntity.BeaconBeamSection)blockEntity.checkingBeamSections.getLast();
        int height = level.getHeight(Heightmap.Types.WORLD_SURFACE, xPos, zPos);
        for (int i1 = 0; i1 < 10 && blockpos.getY() <= height; ++i1) {
            BlockState blockstate = level.getBlockState(blockpos);
            Integer colorMultiplier = blockstate.getBeaconColorMultiplier((LevelReader)level, blockpos, pos);
            if (colorMultiplier != null) {
                if (blockEntity.checkingBeamSections.size() <= 1) {
                    beamSection = new BeaconBlockEntity.BeaconBeamSection(colorMultiplier.intValue());
                    blockEntity.checkingBeamSections.add(beamSection);
                } else if (beamSection != null) {
                    if (colorMultiplier.intValue() == beamSection.getColor()) {
                        ((BeaconBeamSectionAccessor)beamSection).invokeIncreaseHeight();
                    } else {
                        beamSection = new BeaconBlockEntity.BeaconBeamSection(FastColor.ARGB32.average((int)beamSection.getColor(), (int)colorMultiplier));
                        blockEntity.checkingBeamSections.add(beamSection);
                    }
                }
            } else {
                if (beamSection == null || blockstate.getLightBlock((BlockGetter)level, blockpos) >= 15 && !blockstate.is(Blocks.BEDROCK)) {
                    blockEntity.checkingBeamSections.clear();
                    blockEntity.lastCheckY = height;
                    break;
                }
                ((BeaconBeamSectionAccessor)beamSection).invokeIncreaseHeight();
            }
            blockpos = blockpos.above();
            ++blockEntity.lastCheckY;
        }
        int levels = blockEntity.levels;
        if (level.getGameTime() % 80L == 0L) {
            if (!blockEntity.beamSections.isEmpty()) {
                blockEntity.levels = EnchantedBeaconBlockEntity.updateBase(level, xPos, yPos, zPos);
            }
            if (blockEntity.levels > 0 && !blockEntity.beamSections.isEmpty()) {
                EnchantedBeaconBlockEntity.applyEffects(blockEntity, level, pos, blockEntity.levels, (Holder<MobEffect>)blockEntity.primaryPower, (Holder<MobEffect>)blockEntity.secondaryPower);
                EnchantedBeaconBlockEntity.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.BEACON_AMBIENT);
            }
        }
        if (blockEntity.lastCheckY >= height) {
            blockEntity.lastCheckY = level.getMinBuildHeight() - 1;
            boolean flag = levels > 0;
            blockEntity.beamSections = blockEntity.checkingBeamSections;
            if (!level.isClientSide) {
                boolean flag1;
                boolean bl = flag1 = blockEntity.levels > 0;
                if (!flag && flag1) {
                    EnchantedBeaconBlockEntity.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.BEACON_ACTIVATE);
                    for (ServerPlayer serverplayer : level.getEntitiesOfClass(ServerPlayer.class, new AABB((double)xPos, (double)yPos, (double)zPos, (double)xPos, (double)(yPos - 4), (double)zPos).inflate(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.CONSTRUCT_BEACON.trigger(serverplayer, blockEntity.levels);
                    }
                } else if (flag && !flag1) {
                    EnchantedBeaconBlockEntity.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(Level pLevel, int pX, int pY, int pZ) {
        int k;
        int i = 0;
        int j = 1;
        while (j <= 4 && (k = pY - j) >= pLevel.getMinBuildHeight()) {
            boolean flag = true;
            block1: for (int l = pX - j; l <= pX + j && flag; ++l) {
                for (int i1 = pZ - j; i1 <= pZ + j; ++i1) {
                    if (pLevel.getBlockState(new BlockPos(l, k, i1)).is(BlockTags.BEACON_BASE_BLOCKS)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            i = j++;
        }
        return i;
    }

    private static void applyEffects(EnchantedBeaconBlockEntity blockEntity, Level level, BlockPos pos, int levels, Holder<MobEffect> primary, Holder<MobEffect> secondary) {
        if (!level.isClientSide && primary != null) {
            boolean visible = !blockEntity.hasEnchantment(EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.CONCEALED));
            double range = levels * 10 + 10;
            Holder<Enchantment> rangedHolder = EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.RANGED);
            if (blockEntity.hasEnchantment(rangedHolder)) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel(rangedHolder);
                range *= 1.0 + (double)enchantmentLevel * 0.5;
            }
            int amplifier = 0;
            if (levels >= 4 && primary == secondary) {
                amplifier = 1;
            }
            int duration = (9 + levels * 2) * 20;
            AABB aabb = new AABB(pos).inflate(range).expandTowards(0.0, (double)level.getHeight(), 0.0);
            List players = level.getEntitiesOfClass(Player.class, aabb);
            for (Player player : players) {
                player.addEffect(new MobEffectInstance(primary, duration, amplifier, true, visible));
            }
            if (levels >= 4 && primary != secondary && secondary != null) {
                for (Player player : players) {
                    player.addEffect(new MobEffectInstance(secondary, duration, 0, true, visible));
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)this.lockKey, (Component)this.getDisplayName()) ? new EnchantedBeaconMenu(containerId, (Container)inventory, this.dataAccess, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos())) : null;
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }
}

