/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.BeehiveBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import com.mrbysco.enchantableblocks.util.TagHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class EnchantedBeehiveBlockEntity
extends BeehiveBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    public EnchantedBeehiveBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENCHANTED_BEEHIVE_BLOCK_ENTITY.get();
    }

    public boolean isFull() {
        int max = 3;
        if (this.hasEnchantment(ModTags.General.STORAGE_UPGRADE)) {
            max += Mth.clamp((int)this.getEnchantmentLevel(ModTags.General.STORAGE_UPGRADE), (int)0, (int)3);
        }
        return this.stored.size() == max;
    }

    public void addOccupant(Entity occupant) {
        if (!this.isFull()) {
            occupant.stopRiding();
            occupant.ejectPassengers();
            CompoundTag compoundtag = new CompoundTag();
            occupant.save(compoundtag);
            BeehiveBlockEntity.IGNORED_BEE_TAGS.forEach(arg_0 -> ((CompoundTag)compoundtag).remove(arg_0));
            boolean hasNectar = compoundtag.getBoolean("HasNectar");
            int time = hasNectar ? 2400 : 600;
            float multiplier = 1.0f;
            Holder<Enchantment> speedHolder = EnchantmentUtil.getEnchantmentHolder(this.level, ModEnchantments.SPEED);
            if (this.hasEnchantment(speedHolder)) {
                int enchantmentLevel = this.getEnchantmentLevel(speedHolder);
                multiplier = 1.0f - 0.1f * (float)enchantmentLevel;
            }
            time = (int)((float)time * multiplier);
            this.storeBee(new BeehiveBlockEntity.Occupant(CustomData.of((CompoundTag)compoundtag), 0, time));
            if (this.level != null) {
                Bee bee;
                if (occupant instanceof Bee && (bee = (Bee)occupant).hasSavedFlowerPos() && (!((BeehiveBlockEntityAccessor)((Object)this)).invokeHasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = bee.getSavedFlowerPos();
                }
                BlockPos blockpos = this.getBlockPos();
                this.level.playSound(null, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)occupant, (BlockState)this.getBlockState()));
            }
            occupant.discard();
            super.setChanged();
        }
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }
}

