/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity.furnace;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.AbstractFurnaceBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import com.mrbysco.enchantableblocks.util.TagHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEnchantedFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    protected AbstractEnchantedFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(blockEntityType, pos, state, recipeType);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        ItemStack fuel;
        boolean hasFuel;
        RecipeHolder recipe;
        SingleRecipeInput singlerecipeinput;
        boolean solarRequirements;
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck = blockEntityAccessor.getQuickCheck();
        boolean wasLit = blockEntity.isLit();
        boolean changed = false;
        boolean hasInput = !((ItemStack)blockEntity.items.getFirst()).isEmpty();
        boolean solar = blockEntity.hasEnchantment(EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.SOLAR_RADIANCE));
        boolean bl = solarRequirements = (level.isDay() || level.dimensionType().hasFixedTime() && level.getSkyDarken() < 4) && level.canSeeSky(pos.above());
        if (blockEntity.isLit()) {
            int speed = blockEntity.getSpeed();
            if (solar) {
                blockEntity.litTime = solarRequirements ? 200 : (blockEntity.litTime -= speed);
            } else {
                boolean preservation = blockEntity.hasEnchantment(EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.PRESERVATION));
                if (preservation) {
                    singlerecipeinput = new SingleRecipeInput(blockEntity.getItem(0));
                    RecipeHolder recipeHolder = recipe = hasInput ? (RecipeHolder)quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, level).orElse(null) : null;
                    if (recipe != null) {
                        blockEntity.litTime -= speed;
                    }
                } else {
                    blockEntity.litTime -= speed;
                }
            }
        }
        boolean bl2 = hasFuel = !(fuel = (ItemStack)blockEntity.items.get(1)).isEmpty();
        if (blockEntity.isLit() || (solar && solarRequirements || hasFuel) && hasInput) {
            singlerecipeinput = new SingleRecipeInput(blockEntity.getItem(0));
            recipe = hasInput ? (RecipeHolder)quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, level).orElse(null) : null;
            int i = blockEntity.getMaxStackSize();
            if (!blockEntity.isLit()) {
                if (solar && solarRequirements) {
                    blockEntity.litDuration = blockEntity.litTime = 200;
                } else if (AbstractEnchantedFurnaceBlockEntity.canBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i, blockEntity)) {
                    blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuel, level);
                    if (blockEntity.isLit()) {
                        changed = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            blockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                        } else if (hasFuel) {
                            fuel.shrink(1);
                            if (fuel.isEmpty()) {
                                blockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                            }
                        }
                    }
                }
            }
            if (blockEntity.isLit() && AbstractEnchantedFurnaceBlockEntity.canBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i, blockEntity)) {
                int speed = blockEntity.getSpeed();
                blockEntity.cookingProgress += speed;
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = AbstractEnchantedFurnaceBlockEntity.getTotalCookTime(level, blockEntity);
                    if (blockEntity.enchantedBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i, blockEntity)) {
                        blockEntity.setRecipeUsed(recipe);
                    }
                    changed = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.clamp((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (wasLit != blockEntity.isLit()) {
            changed = true;
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (changed) {
            AbstractEnchantedFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean canBurn(RegistryAccess pRegistryAccess, @Nullable RecipeHolder<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize, AbstractEnchantedFurnaceBlockEntity furnace) {
        if (!((ItemStack)pInventory.get(0)).isEmpty() && pRecipe != null) {
            ItemStack itemstack = ((AbstractCookingRecipe)pRecipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)pRegistryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)pInventory.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            return itemstack1.getCount() + itemstack.getCount() <= pMaxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize() ? true : itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private int getSpeed() {
        int speed = 1;
        Holder<Enchantment> speedHolder = EnchantmentUtil.getEnchantmentHolder(this.level, ModEnchantments.SPEED);
        if (this.hasEnchantment(speedHolder)) {
            int enchantmentLevel = this.getEnchantmentLevel(speedHolder);
            speed += enchantmentLevel;
        }
        return speed;
    }

    private boolean enchantedBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipeHolder, NonNullList<ItemStack> inventory, int maxStackSize, AbstractEnchantedFurnaceBlockEntity furnace) {
        if (recipeHolder != null && AbstractEnchantedFurnaceBlockEntity.canBurn(registryAccess, recipeHolder, inventory, maxStackSize, furnace)) {
            ItemStack inputStack = (ItemStack)inventory.getFirst();
            ItemStack craftedStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            Holder<Enchantment> yieldHolder = EnchantmentUtil.getEnchantmentHolder(this.level, ModEnchantments.YIELD);
            if (this.hasEnchantment(yieldHolder) && craftedStack.getCount() < craftedStack.getMaxStackSize() && !craftedStack.is(ModTags.Items.YIELD_BLACKLIST)) {
                int enchantmentLevel = this.getEnchantmentLevel(yieldHolder);
                int count = 1 + enchantmentLevel;
                craftedStack.setCount(Mth.clamp((int)count, (int)1, (int)craftedStack.getMaxStackSize()));
            }
            ItemStack resultStack = (ItemStack)inventory.get(2);
            if (this.hasEnchantment(EnchantmentUtil.getEnchantmentHolder(this.level, ModEnchantments.EXPORTING)) && this.getBlockState() != null) {
                IItemHandler itemHandler;
                BlockEntity blockEntity;
                Direction direction = (Direction)this.getBlockState().getValue((Property)AbstractFurnaceBlock.FACING);
                BlockPos leftPos = this.getBlockPos().relative(direction.getClockWise());
                BlockPos rightPos = this.getBlockPos().relative(direction.getCounterClockWise());
                if (this.level.isLoaded(leftPos) && (blockEntity = this.level.getBlockEntity(leftPos)) != null && (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, leftPos, (Object)direction.getCounterClockWise())) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
                if (this.level.isLoaded(rightPos) && (blockEntity = this.level.getBlockEntity(rightPos)) != null && (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, rightPos, (Object)direction.getClockWise())) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
            }
            if (resultStack.isEmpty()) {
                inventory.set(2, (Object)craftedStack.copy());
            } else if (resultStack.is(craftedStack.getItem())) {
                resultStack.setCount(Mth.clamp((int)(resultStack.getCount() + craftedStack.getCount()), (int)1, (int)resultStack.getMaxStackSize()));
            }
            if (inputStack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            inputStack.shrink(1);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level level, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(blockEntity.getItem(0));
        int cookTime = blockEntityAccessor.getQuickCheck().getRecipeFor((RecipeInput)singlerecipeinput, level).map(recipeHolder -> ((AbstractCookingRecipe)recipeHolder.value()).getCookingTime()).orElse(200);
        Holder<Enchantment> speedHolder = EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.SPEED);
        if (blockEntity.hasEnchantment(speedHolder)) {
            int n = blockEntity.getEnchantmentLevel(speedHolder);
        }
        return cookTime;
    }

    protected int getBurnDuration(ItemStack fuel, @NotNull Level level) {
        int burnDuration = super.getBurnDuration(fuel);
        Holder<Enchantment> fuelEfficiencyHolder = EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.BLOCK_EFFICIENCY);
        if (burnDuration != 0 && this.hasEnchantment(fuelEfficiencyHolder)) {
            int enchantmentLevel = this.getEnchantmentLevel(fuelEfficiencyHolder);
            burnDuration = Mth.ceil((float)((float)burnDuration * (1.0f + (float)enchantmentLevel * 0.2f)));
        }
        return burnDuration;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }
}

