/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Axis;
import com.mrbysco.enchantableblocks.block.EnchantedChestBlock;
import com.mrbysco.enchantableblocks.block.blockentity.EnchantedTrappedChestBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.client.CustomRenderType;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnchantedChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private boolean xmasTextures;
    private boolean renderEnchantment = true;

    public EnchantedChestRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = context.bakeLayer(ModelLayers.CHEST);
        this.bottom = modelpart.getChild(BOTTOM);
        this.lid = modelpart.getChild(LID);
        this.lock = modelpart.getChild(LOCK);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level;
        boolean flag;
        BlockState state;
        Block block;
        if (blockEntity.getLevel() == null) {
            return;
        }
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            this.renderEnchantment = !enchantable.hideGlint();
        }
        if ((block = (state = (flag = (level = blockEntity.getLevel()) != null) ? blockEntity.getBlockState() : (BlockState)((EnchantedChestBlock)((Object)ModRegistry.ENCHANTED_CHEST.get())).defaultBlockState().setValue((Property)EnchantedChestBlock.FACING, (Comparable)Direction.SOUTH)).getBlock()) instanceof AbstractChestBlock) {
            poseStack.pushPose();
            float yRot = ((Direction)state.getValue((Property)EnchantedChestBlock.FACING)).toYRot();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult result = DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)result.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)blockEntity)))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)result.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = this.getMaterial(blockEntity);
            PoseStack.Pose pose = poseStack.last();
            VertexConsumer vertexconsumer = this.renderEnchantment ? VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(bufferSource.getBuffer(CustomRenderType.GLINT), pose, 0.0078125f), (VertexConsumer)material.buffer(bufferSource, RenderType::entityCutout)) : material.buffer(bufferSource, RenderType::entityCutout);
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
            poseStack.popPose();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float pLidAngle, int packedLight, int pPackedOverlay) {
        lockPart.xRot = lidPart.xRot = -(pLidAngle * 1.5707964f);
        lidPart.render(poseStack, consumer, packedLight, pPackedOverlay);
        lockPart.render(poseStack, consumer, packedLight, pPackedOverlay);
        bottomPart.render(poseStack, consumer, packedLight, pPackedOverlay);
    }

    protected Material getMaterial(T blockEntity) {
        if (this.xmasTextures) {
            return Sheets.CHEST_XMAS_LOCATION;
        }
        return blockEntity instanceof EnchantedTrappedChestBlockEntity ? Sheets.CHEST_TRAP_LOCATION : Sheets.CHEST_LOCATION;
    }
}

