/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.enderstorage.network.TankSynchroniser;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TileEnderTank
extends TileFrequencyOwner {
    public int rotation;
    public final EnderTankState liquid_state = new EnderTankState();
    public final PressureState pressure_state = new PressureState();
    private final CapabilityCache capCache = new CapabilityCache();
    @Nullable
    private IFluidHandler fluidHandler;
    private boolean described;

    public TileEnderTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderStorageModContent.ENDER_TANK_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        assert (this.level != null);
        this.pressure_state.update(this.level.isClientSide);
        if (!this.level.isClientSide && this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.level.isClientSide);
    }

    @Override
    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        if (p_155231_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)p_155231_;
            this.capCache.setLevelPos(serverLevel, this.getBlockPos());
        }
    }

    private void ejectLiquid() {
        EnderLiquidStorage source = this.getStorage();
        for (Direction side : Direction.BY_3D_DATA) {
            int qty;
            IFluidHandler dest = (IFluidHandler)this.capCache.getCapabilityOr(Capabilities.FluidHandler.BLOCK, side, (Object)EmptyFluidHandler.INSTANCE);
            FluidStack drain = source.drain(100, IFluidHandler.FluidAction.SIMULATE);
            if (drain.isEmpty() || (qty = dest.fill(drain, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
            source.drain(qty, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onFrequencySet() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            this.liquid_state.setFrequency(this.frequency);
        }
        this.invalidateCapabilities();
        this.fluidHandler = null;
    }

    @Override
    public EnderLiquidStorage getStorage() {
        assert (this.level != null);
        return EnderStorageManager.instance(this.level.isClientSide).getStorage(this.frequency, EnderLiquidStorage.TYPE);
    }

    @Override
    public void onPlaced(@Nullable LivingEntity entity) {
        assert (this.level != null);
        this.rotation = entity != null ? (int)Math.floor((double)(entity.getYRot() * 4.0f / 360.0f) + 2.5) & 3 : 0;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        if (!this.level.isClientSide) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putByte("rot", (byte)this.rotation);
        tag.putBoolean("ir", this.pressure_state.invert_redstone);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = tag.getByte("rot") & 3;
        this.pressure_state.invert_redstone = tag.getBoolean("ir");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = packet.readUByte() & 3;
        this.liquid_state.s_liquid = packet.readFluidStack();
        this.pressure_state.a_pressure = packet.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(Player player, int subHit, InteractionHand hand) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getStorage());
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.getAmount() > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.getAmount() / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    @Override
    public boolean rotate() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            this.rotation = (this.rotation + 1) % 4;
            this.sendUpdatePacket();
        }
        return true;
    }

    @Override
    public int comparatorOutput() {
        EnderLiquidStorage tank = this.getStorage();
        FluidStack fluid = tank.getFluid();
        return fluid.getAmount() * 14 / tank.getCapacity() + (fluid.getAmount() > 0 ? 1 : 0);
    }

    public IFluidHandler getFluidHandler() {
        if (this.fluidHandler == null) {
            this.fluidHandler = this.getStorage();
        }
        return this.fluidHandler;
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 4, TileEnderTank.this.level.registryAccess());
            packet.writePos(TileEnderTank.this.getBlockPos());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk((BlockEntity)TileEnderTank.this);
        }

        @Override
        public void onLiquidChanged() {
            assert (TileEnderTank.this.level != null);
            TileEnderTank.this.level.getChunkSource().getLightEngine().checkBlock(TileEnderTank.this.worldPosition);
        }
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            assert (TileEnderTank.this.level != null);
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.level.hasNeighborSignal(TileEnderTank.this.getBlockPos()) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 5, TileEnderTank.this.level.registryAccess());
            packet.writePos(TileEnderTank.this.getBlockPos());
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk((BlockEntity)TileEnderTank.this);
        }

        public void invert() {
            assert (TileEnderTank.this.level != null);
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.level.getChunk(TileEnderTank.this.worldPosition).setUnsaved(true);
        }
    }
}

