/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import appeng.api.stacks.AEKey;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.common.me.taglist.TagExpParser;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class TagPriorityList
implements IPartitionList {
    private final String rawWhiteListExpression;
    private final String rawBlackListExpression;
    private final Predicate<Set<String>> whiteListPredicate;
    private final Predicate<Set<String>> blackListPredicate;
    private final boolean isWhitelistActive;
    private final Reference2BooleanMap<Object> memory = new Reference2BooleanOpenHashMap();

    public TagPriorityList(String whiteListExpression, String blackListExpression) {
        this.rawWhiteListExpression = this.removeBlank(whiteListExpression != null ? whiteListExpression : "");
        this.rawBlackListExpression = this.removeBlank(blackListExpression != null ? blackListExpression : "");
        this.whiteListPredicate = TagExpParser.compile(this.rawWhiteListExpression);
        this.blackListPredicate = TagExpParser.compile(this.rawBlackListExpression);
        this.isWhitelistActive = !this.rawWhiteListExpression.isBlank();
    }

    private String removeBlank(String raw) {
        return raw.replaceAll("\\s+", "");
    }

    public boolean isListed(AEKey input) {
        if (this.isEmpty()) {
            return true;
        }
        return this.memory.computeIfAbsent(input.getPrimaryKey(), this::eval);
    }

    public boolean isEmpty() {
        return this.rawWhiteListExpression.isBlank() && this.rawBlackListExpression.isBlank();
    }

    public Iterable<AEKey> getItems() {
        return List.of();
    }

    private boolean eval(@NotNull Object input) {
        boolean whiteMatches = TagExpParser.evaluate(this.whiteListPredicate, input);
        boolean blackMatches = TagExpParser.evaluate(this.blackListPredicate, input);
        if (this.isWhitelistActive) {
            return whiteMatches && !blackMatches;
        }
        return !blackMatches;
    }
}

