/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts.base;

import appeng.api.AECapabilities;
import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.core.stats.AdvancementTriggers;
import appeng.helpers.IPriorityHost;
import appeng.helpers.InterfaceLogicHost;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartAdjacentApi;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class PartSpecialStorageBus
extends UpgradeablePart
implements IGridTickable,
IStorageProvider,
IPriorityHost {
    protected final IActionSource source;
    protected final StorageBusInventory handler = this.createHandler();
    @Nullable
    protected Component handlerDescription;
    protected final PartAdjacentApi<MEStorage> adjacentStorageAccessor;
    @Nullable
    protected Map<AEKeyType, ExternalStorageStrategy> externalStorageStrategies;
    protected boolean wasOnline = false;
    protected int priority = 0;
    protected PendingUpdateStatus updateStatus = PendingUpdateStatus.FAST_UPDATE;
    protected ITickingMonitor monitor = null;
    protected IPartitionList filter = null;

    public PartSpecialStorageBus(IPartItem<?> partItem) {
        super(partItem);
        this.adjacentStorageAccessor = new PartAdjacentApi((AEBasePart)this, AECapabilities.ME_STORAGE);
        this.source = new MachineSource((IActionHost)this);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this).addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        builder.registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        builder.registerSetting(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
    }

    protected final void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
            this.remountStorage();
        }
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.forceUpdate();
        this.getHost().markForSave();
    }

    public void upgradesChanged() {
        super.upgradesChanged();
        this.forceUpdate();
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.priority = data.getInt("priority");
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putInt("priority", this.priority);
    }

    public final boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    protected final void openConfigMenu(Player player) {
        MenuOpener.open(this.getMenuType(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.relative(this.getSide()).equals((Object)neighbor)) {
            BlockEntity te = level.getBlockEntity(neighbor);
            if (te == null) {
                this.updateTarget(false);
            } else {
                this.scheduleUpdate();
            }
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.updateStatus != PendingUpdateStatus.NO_UPDATE) {
            this.updateTarget(false);
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return this.updateStatus == PendingUpdateStatus.SLOW_UPDATE ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    private boolean hasRegisteredCellToNetwork() {
        return this.getMainNode().isOnline() && !(this.handler.getDelegate() instanceof NullInventory);
    }

    public Component getConnectedToDescription() {
        return this.handlerDescription;
    }

    protected void forceUpdate() {
        if (this.getMainNode().isReady()) {
            this.updateTarget(true);
        }
    }

    protected void updateTarget(boolean forceFullUpdate) {
        ITickingMonitor tickingMonitor;
        MEStorage newInventory;
        MEStorage mEStorage;
        if (this.isClientSide()) {
            return;
        }
        MEStorage foundMonitor = null;
        Map<AEKeyType, MEStorage> foundExternalApi = Collections.emptyMap();
        if (Platform.areBlockEntitiesTicking((Level)this.getLevel(), (BlockPos)this.getBlockEntity().getBlockPos().relative(this.getSide()))) {
            this.updateStatus = PendingUpdateStatus.NO_UPDATE;
            foundMonitor = (MEStorage)this.adjacentStorageAccessor.find();
            if (foundMonitor == null) {
                foundExternalApi = new IdentityHashMap(2);
                this.findExternalStorages(foundExternalApi);
            }
        } else {
            this.updateStatus = PendingUpdateStatus.SLOW_UPDATE;
        }
        if (!forceFullUpdate && (mEStorage = this.handler.getDelegate()) instanceof CompositeStorage) {
            CompositeStorage compositeStorage = (CompositeStorage)mEStorage;
            if (!foundExternalApi.isEmpty()) {
                compositeStorage.setStorages(foundExternalApi);
                this.handlerDescription = compositeStorage.getDescription();
                return;
            }
        }
        if (!forceFullUpdate && foundMonitor == this.handler.getDelegate()) {
            return;
        }
        boolean wasSleeping = this.monitor == null;
        boolean wasRegistered = this.hasRegisteredCellToNetwork();
        if (foundMonitor != null) {
            newInventory = foundMonitor;
            this.checkStorageBusOnInterface();
            this.handlerDescription = newInventory.getDescription();
        } else if (!foundExternalApi.isEmpty()) {
            newInventory = new CompositeStorage(foundExternalApi);
            this.handlerDescription = newInventory.getDescription();
        } else {
            newInventory = NullInventory.of();
            this.handlerDescription = null;
        }
        this.handler.setDelegate(newInventory);
        this.handler.setAccessRestriction((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
        this.handler.setWhitelist(this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.handler.setPartitionList(this.createFilter());
        this.handler.setVoidOverflow(this.isUpgradedWith((ItemLike)AEItems.VOID_CARD));
        boolean filterOnExtract = this.getConfigManager().getSetting(Settings.FILTER_ON_EXTRACT) == YesNo.YES;
        this.handler.setExtractFiltering(filterOnExtract, this.isExtractableOnly() && filterOnExtract);
        this.monitor = newInventory instanceof ITickingMonitor ? (tickingMonitor = (ITickingMonitor)newInventory) : null;
        if (wasSleeping != (this.monitor == null)) {
            this.getMainNode().ifPresent((grid, node) -> {
                ITickManager tm = grid.getTickManager();
                if (this.monitor == null) {
                    tm.sleepDevice(node);
                } else {
                    tm.wakeDevice(node);
                }
            });
        }
        if (wasRegistered != this.hasRegisteredCellToNetwork()) {
            this.remountStorage();
        }
    }

    protected boolean isExtractableOnly() {
        return this.getConfigManager().getSetting(Settings.STORAGE_FILTER) == StorageFilter.EXTRACTABLE_ONLY;
    }

    protected void findExternalStorages(Map<AEKeyType, MEStorage> storages) {
        boolean extractableOnly = this.isExtractableOnly();
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.getExternalStorageStrategies().entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(extractableOnly, this::invalidateOnExternalStorageChange);
            if (wrapper == null) continue;
            storages.put(entry.getKey(), wrapper);
        }
    }

    protected void invalidateOnExternalStorageChange() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    protected void checkStorageBusOnInterface() {
        MinecraftServer server;
        ServerPlayer player;
        BlockEntity targetBe;
        Direction oppositeSide = this.getSide().getOpposite();
        BlockPos targetPos = this.getBlockEntity().getBlockPos().relative(this.getSide());
        BlockEntity targetHost = targetBe = this.getLevel().getBlockEntity(targetPos);
        if (targetBe instanceof IPartHost) {
            IPartHost partHost = (IPartHost)targetBe;
            targetHost = partHost.getPart(oppositeSide);
        }
        if (targetHost instanceof InterfaceLogicHost && (player = IPlayerRegistry.getConnected((MinecraftServer)(server = this.getLevel().getServer()), (int)this.getActionableNode().getOwningPlayerId())) != null) {
            AdvancementTriggers.RECURSIVE.trigger(player);
        }
    }

    public void mountInventories(IStorageMounts mounts) {
        if (this.hasRegisteredCellToNetwork()) {
            mounts.mount((MEStorage)this.handler, this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.remountStorage();
    }

    private Map<AEKeyType, ExternalStorageStrategy> getExternalStorageStrategies() {
        if (this.externalStorageStrategies == null) {
            BlockEntity host = this.getHost().getBlockEntity();
            this.externalStorageStrategies = StackWorldBehaviors.createExternalStorageStrategies((ServerLevel)((ServerLevel)host.getLevel()), (BlockPos)host.getBlockPos().relative(this.getSide()), (Direction)this.getSide().getOpposite());
        }
        return this.externalStorageStrategies;
    }

    protected abstract IPartitionList createFilter();

    public abstract MenuType<?> getMenuType();

    protected StorageBusInventory createHandler() {
        return new StorageBusInventory(NullInventory.of());
    }

    protected void scheduleUpdate() {
        if (this.isClientSide()) {
            return;
        }
        this.updateStatus = PendingUpdateStatus.FAST_UPDATE;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public static class StorageBusInventory
    extends MEInventoryHandler {
        public StorageBusInventory(MEStorage inventory) {
            super(inventory);
        }

        public MEStorage getDelegate() {
            return super.getDelegate();
        }

        public void setDelegate(MEStorage delegate) {
            super.setDelegate(delegate);
        }

        public void setAccessRestriction(AccessRestriction setting) {
            this.setAllowExtraction(setting.isAllowExtraction());
            this.setAllowInsertion(setting.isAllowInsertion());
        }
    }

    public static enum PendingUpdateStatus {
        FAST_UPDATE,
        SLOW_UPDATE,
        NO_UPDATE;

    }
}

