/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.xmod.jade;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.core.localization.InGameTooltip;
import com.glodblock.github.extendedae.common.parts.PartSmartAnnihilationPlane;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class PlaneTooltip
implements BodyProvider<PartSmartAnnihilationPlane>,
ServerDataProvider<PartSmartAnnihilationPlane> {
    static final PlaneTooltip INSTANCE = new PlaneTooltip();
    private static final String TAG_ENCHANTMENTS = "planeEnchantments";

    public void buildTooltip(PartSmartAnnihilationPlane object, TooltipContext context, TooltipBuilder tooltip) {
        CompoundTag serverData = context.serverData();
        if (serverData.contains(TAG_ENCHANTMENTS, 10)) {
            tooltip.addLine((Component)InGameTooltip.EnchantedWith.text());
            CompoundTag enchantments = serverData.getCompound(TAG_ENCHANTMENTS);
            HolderLookup.RegistryLookup enchantmentRegistry = context.registries().lookupOrThrow(Registries.ENCHANTMENT);
            for (String enchantmentId : enchantments.getAllKeys()) {
                Optional enchantment = enchantmentRegistry.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)enchantmentId)));
                int level = enchantments.getInt(enchantmentId);
                enchantment.ifPresent(holder -> tooltip.addLine(Enchantment.getFullname((Holder)holder, (int)level)));
            }
        }
    }

    public void provideServerData(Player player, PartSmartAnnihilationPlane plane, CompoundTag serverData) {
        ItemEnchantments enchantments = plane.getEnchantments();
        if (enchantments != null && !enchantments.isEmpty()) {
            CompoundTag enchantmentsTag = new CompoundTag();
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                enchantmentsTag.putInt(((Holder)entry.getKey()).getRegisteredName(), entry.getIntValue());
            }
            serverData.put(TAG_ENCHANTMENTS, (Tag)enchantmentsTag);
        }
    }
}

