/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.popup.PopupCustomColor;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class GuiTabEditAbstract
extends GuiTabCore {
    protected SecurityLevel mSecurityLevel;
    public ColorButton mColorButton;
    public FluxEditBox mNetworkName;
    public FluxEditBox mPassword;

    public GuiTabEditAbstract(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    public abstract void onEditSettingsChanged();

    @Override
    public void init() {
        super.init();
        if (this.getNetwork().isValid() || this.getNavigationTab() == EnumNavigationTab.TAB_CREATE) {
            this.mNetworkName = FluxEditBox.create(FluxTranslate.NETWORK_NAME.get() + ": ", this.font, this.leftPos + 16, this.topPos + 28, 144, 12).setOutlineColor(-8355712);
            this.mNetworkName.setMaxLength(24);
            this.mNetworkName.setResponder(string -> this.onEditSettingsChanged());
            this.addRenderableWidget((GuiEventListener)this.mNetworkName);
            this.mPassword = FluxEditBox.create(FluxTranslate.NETWORK_PASSWORD.get() + ": ", this.font, this.leftPos + 16, this.topPos + 62, 144, 12).setOutlineColor(-8355712).setTextInvisible();
            this.mPassword.setFilter(string -> string != null && (string.isEmpty() || !FluxUtils.isBadPassword(string)));
            this.mPassword.setMaxLength(16);
            this.mPassword.setResponder(string -> this.onEditSettingsChanged());
            this.mPassword.setVisible(this.mSecurityLevel == SecurityLevel.ENCRYPTED);
            this.addRenderableWidget((GuiEventListener)this.mPassword);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid() || this.getNavigationTab() == EnumNavigationTab.TAB_CREATE) {
            gr.drawCenteredString(this.font, this.getNavigationTab().getTranslatedName(), this.leftPos + 88, this.topPos + 10, -4934476);
            gr.drawString(this.font, FluxTranslate.NETWORK_SECURITY.get() + ": " + String.valueOf(ChatFormatting.AQUA) + this.mSecurityLevel.getName(), this.leftPos + 16, this.topPos + 47, -8355712);
            gr.drawString(this.font, FluxTranslate.NETWORK_COLOR.get() + ":", this.leftPos + 16, this.topPos + 89, -8355712);
            this.renderNetwork(gr, this.mNetworkName.getValue(), this.mColorButton.mColor, this.topPos + 126);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && mouseX >= (double)(this.leftPos + 36) && mouseX < (double)(this.leftPos + 96) && mouseY >= (double)(this.topPos + 48) && mouseY < (double)(this.topPos + 56)) {
            this.mSecurityLevel = (SecurityLevel)FluxUtils.cycle((Enum)this.mSecurityLevel, (Enum[])SecurityLevel.VALUES);
            this.mPassword.setVisible(this.mSecurityLevel == SecurityLevel.ENCRYPTED);
            this.onEditSettingsChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof ColorButton) {
            this.mColorButton.setSelected(false);
            this.mColorButton = (ColorButton)button;
            this.mColorButton.setSelected(true);
            this.onEditSettingsChanged();
            if (mouseButton == 1) {
                this.openPopup(new PopupCustomColor(this, this.mColorButton.mColor));
            }
        }
    }

    @Override
    public void onPopupClose(GuiPopupCore<?> popUp) {
        super.onPopupClose(popUp);
        if (popUp instanceof PopupCustomColor) {
            this.mColorButton.mColor = ((PopupCustomColor)popUp).mCurrentColor;
            this.onEditSettingsChanged();
        }
    }
}

