/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.util.FluxUtils;

@ParametersAreNonnullByDefault
public class FluxPlayerData
implements INBTSerializable<CompoundTag> {
    private boolean superAdmin = false;
    private int wirelessMode = 0;
    private int wirelessNetwork = -1;

    public boolean isSuperAdmin() {
        return this.superAdmin;
    }

    public boolean setSuperAdmin(boolean superAdmin) {
        if (this.superAdmin != superAdmin) {
            this.superAdmin = superAdmin;
            return true;
        }
        return false;
    }

    public int getWirelessMode() {
        return this.wirelessMode;
    }

    public void setWirelessMode(int wirelessMode) {
        this.wirelessMode = wirelessMode;
    }

    public int getWirelessNetwork() {
        return this.wirelessNetwork;
    }

    public void setWirelessNetwork(int wirelessNetwork) {
        this.wirelessNetwork = wirelessNetwork;
    }

    public void copy(FluxPlayerData other) {
        this.superAdmin = other.superAdmin;
        this.wirelessMode = other.wirelessMode;
        this.wirelessNetwork = other.wirelessNetwork;
    }

    public static boolean canActivateSuperAdmin(ServerPlayer player) {
        return FluxConfig.enableSuperAdmin && player.hasPermissions(FluxConfig.superAdminRequiredPermission);
    }

    public static boolean isPlayerSuperAdmin(@Nonnull ServerPlayer player) {
        if (FluxConfig.enableSuperAdmin) {
            return FluxUtils.getPlayerData(player).isSuperAdmin();
        }
        return false;
    }

    @Nonnull
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("super_admin", this.superAdmin);
        tag.putInt("wireless_mode", this.wirelessMode);
        tag.putInt("wireless_network", this.wirelessNetwork);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.superAdmin = nbt.getBoolean("super_admin");
        this.wirelessMode = nbt.getInt("wireless_mode");
        this.wirelessNetwork = nbt.getInt("wireless_network");
    }
}

