/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.geometry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.model.cache.QuadCacheKey;
import xfacthd.framedblocks.api.model.cache.SimpleQuadCacheKey;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.util.ConfigView;

public abstract class Geometry {
    public void transformQuad(QuadMap quadMap, BakedQuad quad, ModelData data) {
        this.transformQuad(quadMap, quad);
    }

    public abstract void transformQuad(QuadMap var1, BakedQuad var2);

    public boolean hasUncachedPostProcessing() {
        return false;
    }

    public void postProcessUncachedQuads(List<BakedQuad> quads) {
    }

    public boolean forceUngeneratedBaseModel() {
        return false;
    }

    public boolean useBaseModel() {
        return this.forceUngeneratedBaseModel();
    }

    public BakedModel getBaseModel(BakedModel baseModel, boolean useAltModel) {
        return baseModel;
    }

    public boolean transformAllQuads() {
        return false;
    }

    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ChunkRenderTypeSet.none();
    }

    public void getAdditionalQuads(ArrayList<BakedQuad> quads, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
    }

    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
    }

    public ChunkRenderTypeSet getOverlayRenderTypes(RandomSource rand, ModelData extraData) {
        return ChunkRenderTypeSet.none();
    }

    public void getGeneratedOverlayQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType layer) {
    }

    public QuadCacheKey makeCacheKey(CamoContent<?> camo, Object ctCtx, ModelData data) {
        return ctCtx != null ? new SimpleQuadCacheKey(camo, ctCtx) : camo;
    }

    public boolean useSolidNoCamoModel() {
        return false;
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        CamoContent<?> camoContent;
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbData != null && !(camoContent = fbData.getCamoContent()).isEmpty()) {
            BakedModel model = CamoContainerHelper.Client.getOrCreateModel(camoContent);
            TriState camoAO = model.useAmbientOcclusion(camoContent.getAppearanceState(), ModelData.EMPTY, renderType);
            if (camoAO != TriState.DEFAULT) {
                return camoAO;
            }
            if (camoContent.getLightEmission() != 0 || camoContent.isEmissive()) {
                return TriState.FALSE;
            }
        }
        if (ConfigView.Client.INSTANCE.shouldForceAmbientOcclusionOnGlowingBlocks()) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }

    public ItemModelInfo getItemModelInfo() {
        return ItemModelInfo.DEFAULT;
    }

    public ModelData getAuxModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileData) {
        return ModelData.EMPTY;
    }
}

