/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedDoubleStairsBlockEntity
extends FramedDoubleBlockEntity {
    public FramedVerticalSlopedDoubleStairsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_VERTICAL_SLOPED_DOUBLE_STAIRS.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)this.getBlockState().getValue(PropertyHolder.ROTATION));
        Direction dirTwo = rot.withFacing(facing);
        Direction dirThree = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        Direction side = hit.getDirection();
        Vec3 hitVec = hit.getLocation();
        if (side == dirTwo || side == dirThree) {
            return Utils.fractionInDir(hitVec, facing) < 0.5;
        }
        if (side == facing.getOpposite()) {
            double par = Utils.fractionInDir(hitVec, dirTwo.getOpposite());
            double perp = Utils.fractionInDir(hitVec, dirThree);
            return perp > par;
        }
        return false;
    }
}

