/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.common.block.cube.FramedChestBlock;

public final class ChestShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape shapeSingle = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape[] conShapes = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0)};
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            ChestType type = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
            if (type == ChestType.SINGLE) {
                builder.put((Object)state, (Object)shapeSingle);
                continue;
            }
            Direction conDir = FramedChestBlock.getConnectionDirection(state);
            builder.put((Object)state, (Object)conShapes[conDir.get2DDataValue()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private ChestShapes() {
    }
}

