/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class HalfSlopeShapes
implements SplitShapeGenerator {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        map.put(new ShapeKey(false, false), ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(false, true), ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.EAST)));
        map.put(new ShapeKey(true, false), ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(true, true), ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.EAST)));
    });
    public static final ShapeCache<ShapeKey> OCCLUSION_SHAPES = ShapeCache.create(map -> {
        map.put(new ShapeKey(false, false), ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(false, true), ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.EAST)));
        map.put(new ShapeKey(true, false), ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(true, true), ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.EAST)));
    });

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return HalfSlopeShapes.generateShapes(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return HalfSlopeShapes.generateShapes(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, ShapeCache<ShapeKey> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskTop = 4;
        int maskRight = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < 4; ++i) {
            ShapeUtils.makeHorizontalRotations(shapeCache.get(new ShapeKey((i & 1) != 0, (i & 2) != 0)), Direction.NORTH, shapes, i << 2);
        }
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.getValue((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT) != false ? maskRight : 0;
            int idx = dir.get2DDataValue() | (top | right);
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public record ShapeKey(boolean top, boolean right) {
    }
}

