/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.door.DoorDirs;

@CullTest(value={BlockType.FRAMED_GATE, BlockType.FRAMED_IRON_GATE})
public final class GateSkipPredicate
implements SideSkipPredicate {
    public static final GateSkipPredicate INSTANCE = new GateSkipPredicate();

    private GateSkipPredicate() {
    }

    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)BlockStateProperties.DOOR_HINGE);
            boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
            return switch (blockType) {
                case BlockType.FRAMED_GATE, BlockType.FRAMED_IRON_GATE -> GateSkipPredicate.testAgainstGate(dir, hinge, open, adjState, side);
                case BlockType.FRAMED_DOOR, BlockType.FRAMED_IRON_DOOR -> GateSkipPredicate.testAgainstDoor(dir, hinge, open, adjState, side);
                case BlockType.FRAMED_TRAPDOOR, BlockType.FRAMED_IRON_TRAPDOOR -> GateSkipPredicate.testAgainstTrapdoor(dir, hinge, open, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_GATE, BlockType.FRAMED_IRON_GATE})
    private static boolean testAgainstGate(Direction dir, DoorHingeSide hinge, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        DoorHingeSide adjHinge = (DoorHingeSide)adjState.getValue((Property)BlockStateProperties.DOOR_HINGE);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Gate.getDoorEdgeDir(dir, hinge, open, side).isEqualTo(DoorDirs.Gate.getDoorEdgeDir(adjDir, adjHinge, adjOpen, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_DOOR, BlockType.FRAMED_IRON_DOOR})
    private static boolean testAgainstDoor(Direction dir, DoorHingeSide hinge, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        DoorHingeSide adjHinge = (DoorHingeSide)adjState.getValue((Property)BlockStateProperties.DOOR_HINGE);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Gate.getDoorEdgeDir(dir, hinge, open, side).isEqualTo(DoorDirs.Door.getDoorEdgeDir(adjDir, adjHinge, adjOpen, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_TRAPDOOR, BlockType.FRAMED_IRON_TRAPDOOR})
    private static boolean testAgainstTrapdoor(Direction dir, DoorHingeSide hinge, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Gate.getDoorEdgeDir(dir, hinge, open, side).isEqualTo(DoorDirs.Trapdoor.getDoorEdgeDir(adjDir, adjHalf, adjOpen, side.getOpposite()));
    }
}

