/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;

@CullTest(value={BlockType.FRAMED_FENCE})
public final class FenceSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_FENCE -> FenceSkipPredicate.testAgainstFence(state, adjState, side);
                case BlockType.FRAMED_FENCE_GATE -> FenceSkipPredicate.testAgainstFenceGate(state, adjState, side);
                case BlockType.FRAMED_LATTICE_BLOCK -> FenceSkipPredicate.testAgainstLattice(adjState, side);
                case BlockType.FRAMED_POST -> FenceSkipPredicate.testAgainstPost(adjState, side);
                case BlockType.FRAMED_PYRAMID -> FenceSkipPredicate.testAgainstPyramid(adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> FenceSkipPredicate.testAgainstElevatedPyramidSlab(adjState, side);
                case BlockType.FRAMED_UPPER_PYRAMID_SLAB -> FenceSkipPredicate.testAgainstUpperPyramidSlab(adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(BlockState state, BlockState adjState, Direction side) {
        return PillarDirs.Fence.testFenceArmDir(state, adjState, side) || PillarDirs.Fence.isPostDir(side) && PillarDirs.Fence.isPostDir(side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE_GATE}, oneWay=true)
    private static boolean testAgainstFenceGate(BlockState state, BlockState adjState, Direction side) {
        return PillarDirs.Fence.testFenceArmToGateDir(state, adjState, side);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(BlockState adjState, Direction side) {
        boolean adjXAxis = (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
        boolean adjYAxis = (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
        boolean adjZAxis = (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        return PillarDirs.Fence.isPostDir(side) && PillarDirs.Lattice.isPostDir(adjXAxis, adjYAxis, adjZAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        return PillarDirs.Fence.isPostDir(side) && PillarDirs.Post.isPostDir(adjAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PYRAMID})
    private static boolean testAgainstPyramid(BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Fence.isPostDir(side) && SlopeDirs.Pyramid.isPostDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Fence.isPostDir(side) && SlopeDirs.ElevatedPyramidSlab.isPostDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_UPPER_PYRAMID_SLAB})
    private static boolean testAgainstUpperPyramidSlab(BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Fence.isPostDir(side) && SlopeDirs.UpperPyramidSlab.isPostDir(adjDir, adjConnection, side.getOpposite());
    }
}

