/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpawnAlgorithms {
    public static final SpawnAlgorithm OPEN_FIELD = SpawnAlgorithms::openField;
    public static final SpawnAlgorithm INWARD_SPIRAL = SpawnAlgorithms::inwardSpiral;
    private static final BiMap<ResourceLocation, SpawnAlgorithm> NAMED_ALGORITHMS = HashBiMap.create();
    public static final Codec<SpawnAlgorithm> CODEC;
    public static final int MAX_SPAWN_TRIES = 15;

    @Nullable
    private static Vec3 openField(ServerLevel level, Vec3 pos, GatewayEntity gate, Entity toSpawn) {
        double spawnRange = (double)(gate.getBbWidth() / 2.0f) + gate.getGateway().rules().spawnRange();
        for (int i = 0; i < 15; ++i) {
            double y;
            double x = pos.x() + (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            double z = pos.z() + (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            for (y = pos.y() + (double)level.random.nextInt(3 * (int)gate.getGateway().size().getScale()) + 1.0; level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)).isAir() && y > (double)level.getMinBuildHeight(); y -= 1.0) {
            }
            while (!SpawnAlgorithms.noBlockCollision((Level)level, SpawnAlgorithms.getAABB(toSpawn, x, y, z))) {
                y += 1.0;
            }
            if (gate.distanceToSqr(x, y, z) > gate.getGateway().getLeashRangeSq() || !SpawnAlgorithms.noBlockCollision((Level)level, SpawnAlgorithms.getAABB(toSpawn, x, y, z))) continue;
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Nullable
    private static Vec3 inwardSpiral(ServerLevel level, Vec3 pos, GatewayEntity gate, Entity toSpawn) {
        double spawnRange = (double)(gate.getBbWidth() / 2.0f) + gate.getGateway().rules().spawnRange();
        for (int i = 0; i < 15; ++i) {
            double y;
            float scaleFactor = (float)(14 - i) / 15.0f;
            double x = pos.x() + (double)scaleFactor * (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            double z = pos.z() + (double)scaleFactor * (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            for (y = pos.y() + (double)(scaleFactor * (float)level.random.nextInt(3 * (int)gate.getGateway().size().getScale())) + 1.0; level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)).isAir() && y > (double)level.getMinBuildHeight(); y -= 1.0) {
            }
            while (!SpawnAlgorithms.noBlockCollision((Level)level, SpawnAlgorithms.getAABB(toSpawn, x, y, z))) {
                y += 1.0;
            }
            if (gate.distanceToSqr(x, y, z) > gate.getGateway().getLeashRangeSq() || !SpawnAlgorithms.noBlockCollision((Level)level, SpawnAlgorithms.getAABB(toSpawn, x, y, z))) continue;
            return new Vec3(x, y, z);
        }
        return null;
    }

    public static AABB getAABB(Entity e, double x, double y, double z) {
        return e.getDimensions(Pose.STANDING).makeBoundingBox(x, y, z);
    }

    public static void register(ResourceLocation key, SpawnAlgorithm algo) {
        if (NAMED_ALGORITHMS.containsKey((Object)key)) {
            throw new UnsupportedOperationException("Attempted to register a spawn algorithm with duplicate key: " + String.valueOf(key));
        }
        if (NAMED_ALGORITHMS.containsValue((Object)algo)) {
            throw new UnsupportedOperationException("Attempted to register the spawn algorithm " + String.valueOf(key) + " twice.");
        }
        NAMED_ALGORITHMS.put((Object)key, (Object)algo);
    }

    public static boolean noBlockCollision(Level level, AABB pCollisionBox) {
        for (VoxelShape voxelshape : level.getBlockCollisions(null, pCollisionBox)) {
            if (voxelshape.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static {
        SpawnAlgorithms.register(Gateways.loc("open_field"), OPEN_FIELD);
        SpawnAlgorithms.register(Gateways.loc("inward_spiral"), INWARD_SPIRAL);
        CODEC = ResourceLocation.CODEC.xmap(arg_0 -> NAMED_ALGORITHMS.get(arg_0), arg_0 -> NAMED_ALGORITHMS.inverse().get(arg_0));
    }

    public static interface SpawnAlgorithm {
        @Nullable
        public Vec3 spawn(ServerLevel var1, Vec3 var2, GatewayEntity var3, Entity var4);
    }
}

