/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.client;

import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class GeOreLanguageProvider
extends LanguageProvider {
    public GeOreLanguageProvider(PackOutput packOutput) {
        super(packOutput, "geore", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.geore", "GeOre");
        this.generateLang("Coal", GeOreRegistry.COAL_GEORE);
        this.generateLang("Copper", GeOreRegistry.COPPER_GEORE);
        this.generateLang("Diamond", GeOreRegistry.DIAMOND_GEORE);
        this.generateLang("Emerald", GeOreRegistry.EMERALD_GEORE);
        this.generateLang("Gold", GeOreRegistry.GOLD_GEORE);
        this.generateLang("Iron", GeOreRegistry.IRON_GEORE);
        this.generateLang("Lapis", GeOreRegistry.LAPIS_GEORE);
        this.generateLang("Quartz", GeOreRegistry.QUARTZ_GEORE);
        this.generateLang("Redstone", GeOreRegistry.REDSTONE_GEORE);
        this.generateLang("Ancient Debris", GeOreRegistry.ANCIENT_DEBRIS_GEORE);
        this.generateLang("Ruby", GeOreRegistry.RUBY_GEORE);
        this.generateLang("Sapphire", GeOreRegistry.SAPPHIRE_GEORE);
        this.generateLang("Topaz", GeOreRegistry.TOPAZ_GEORE);
        this.generateLang("Zinc", GeOreRegistry.ZINC_GEORE);
        this.generateLang("Uraninite", GeOreRegistry.URANINITE_GEORE);
        this.generateLang("Black Quartz", GeOreRegistry.BLACK_QUARTZ_GEORE);
        this.generateLang("Monazite", GeOreRegistry.MONAZITE_GEORE);
        this.generateLang("Aluminum", GeOreRegistry.ALUMINUM_GEORE);
        this.generateLang("Lead", GeOreRegistry.LEAD_GEORE);
        this.generateLang("Nickel", GeOreRegistry.NICKEL_GEORE);
        this.generateLang("Osmium", GeOreRegistry.OSMIUM_GEORE);
        this.generateLang("Platinum", GeOreRegistry.PLATINUM_GEORE);
        this.generateLang("Silver", GeOreRegistry.SILVER_GEORE);
        this.generateLang("Tin", GeOreRegistry.TIN_GEORE);
        this.generateLang("Tungsten", GeOreRegistry.TUNGSTEN_GEORE);
        this.generateLang("Uranium", GeOreRegistry.URANIUM_GEORE);
        this.generateLang("Allthemodium", GeOreRegistry.ALLTHEMODIUM_GEORE);
        this.generateLang("Vibranium", GeOreRegistry.VIBRANIUM_GEORE);
        this.generateLang("Unobtainium", GeOreRegistry.UNOBTAINIUM_GEORE);
        this.add("geore.configuration.title", "GeOre Settings");
        this.addConfig("Client", "Client", "Client Settings");
        this.addConfig("spyglassIntensity", "Spyglass Intensity", "The intensity of the spyglass color overlay (0.5 = 50%) [Default: 0.5]");
        this.addConfig("General", "General", "General settings");
        this.addConfig("generateCoalGeore", "Generate Coal GeOre", "Generate Coal GeOre [Default: true]");
        this.addConfig("generateCopperGeore", "Generate Copper GeOre", "Generate Copper GeOre [Default: true]");
        this.addConfig("generateDiamondGeore", "Generate Diamond GeOre", "Generate Diamond GeOre [Default: true]");
        this.addConfig("generateEmeraldGeore", "Generate Emerald GeOre", "Generate Emerald GeOre [Default: true]");
        this.addConfig("generateGoldGeore", "Generate Gold GeOre", "Generate Gold GeOre [Default: true]");
        this.addConfig("generateIronGeore", "Generate Iron GeOre", "Generate Iron GeOre [Default: true]");
        this.addConfig("generateLapisGeore", "Generate Lapis GeOre", "Generate Lapis GeOre [Default: true]");
        this.addConfig("generateQuartzGeore", "Generate Quartz GeOre", "Generate Quartz GeOre [Default: true]");
        this.addConfig("generateQuartzInNetherGeore", "Generate Quartz In Nether GeOre", "Generate Quartz In Nether GeOre [Default: true]");
        this.addConfig("generateRedstoneGeore", "Generate Redstone GeOre", "Generate Redstone GeOre [Default: true]");
        this.addConfig("generateBuddingAncientDebris", "Generate Budding Ancient Debris", "Generate Budding Ancient Debris [Default: true]");
        this.addConfig("disablePistonPushForBuddingGeOre", "Disable Piston Push For Budding GeOre", "Disable piston push for budding GeOre (Overrides the vanilla behavior of breaking the block upon being pushed) [Default: false]");
        this.addConfig("ModdedGeneration", "Modded Generation", "Modded Generation Settings");
        this.addConfig("generateRubyGeore", "Generate Ruby GeOre", "Generate Ruby GeOre [Default: false]");
        this.addConfig("generateSapphireGeore", "Generate Sapphire GeOre", "Generate Sapphire GeOre [Default: false]");
        this.addConfig("generateTopazGeore", "Generate Topaz GeOre", "Generate Topaz GeOre [Default: false]");
        this.addConfig("generateZincGeore", "Generate Zinc GeOre", "Generate Zinc GeOre [Default: false]");
        this.addConfig("generateUraniniteGeore", "Generate Uraninite GeOre", "Generate Uraninite GeOre [Default: false]");
        this.addConfig("generateBlackQuartzGeore", "Generate Black Quartz GeOre", "Generate Black Quartz GeOre [Default: false]");
        this.addConfig("generateMonaziteGeore", "Generate Monazite GeOre", "Generate Monazite GeOre [Default: false]");
        this.addConfig("generateAluminumGeore", "Generate Aluminum GeOre", "Generate Aluminum GeOre [Default: false]");
        this.addConfig("generateLeadGeore", "Generate Lead GeOre", "Generate Lead GeOre [Default: false]");
        this.addConfig("generateNickelGeore", "Generate Nickel GeOre", "Generate Nickel GeOre [Default: false]");
        this.addConfig("generateOsmiumGeore", "Generate Osmium GeOre", "Generate Osmium GeOre [Default: false]");
        this.addConfig("generatePlatinumGeore", "Generate Platinum GeOre", "Generate Platinum GeOre [Default: false]");
        this.addConfig("generateSilverGeore", "Generate Silver GeOre", "Generate Silver GeOre [Default: false]");
        this.addConfig("generateTinGeore", "Generate Tin GeOre", "Generate Tin GeOre [Default: false]");
        this.addConfig("generateTungstenGeore", "Generate Tungsten GeOre", "Generate Tungsten GeOre [Default: false]");
        this.addConfig("generateUraniumGeore", "Generate Uranium GeOre", "Generate Uranium GeOre [Default: false]");
        this.addConfig("generateAllthemodiumGeore", "Generate Allthemodium GeOre", "Generate Allthemodium GeOre [Default: false]");
        this.addConfig("generateVibraniumGeore", "Generate Vibranium GeOre", "Generate Vibranium GeOre [Default: false]");
        this.addConfig("generateUnobtainiumGeore", "Generate Unobtainium GeOre", "Generate Unobtainium GeOre [Default: false]");
    }

    public void generateLang(String name, GeOreBlockReg blockReg) {
        this.addBlock((Supplier)blockReg.getBlock(), "Block Of " + name + " GeOre");
        this.addBlock((Supplier)blockReg.getBudding(), "Budding " + name + " GeOre");
        this.addBlock((Supplier)blockReg.getSmallBud(), "Small " + name + " GeOre Bud");
        this.addBlock((Supplier)blockReg.getMediumBud(), "Medium " + name + " GeOre Bud");
        this.addBlock((Supplier)blockReg.getLargeBud(), "Large " + name + " GeOre Bud");
        this.addBlock((Supplier)blockReg.getCluster(), name + " GeOre Cluster");
        this.addBlock((Supplier)blockReg.getTintedGlass(), name + " Tinted Glass");
        this.addItem((Supplier)blockReg.getShard(), name + " GeOre Shard");
        this.addItem((Supplier)blockReg.getSpyglass(), name + " GeOre Spyglass");
    }

    private void addConfig(String path, String name, String description) {
        this.add("geore.configuration." + path, name);
        this.add("geore.configuration." + path + ".tooltip", description);
    }
}

