/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.item;

import com.hollingsworth.arsnouveau.api.block.IPedestalMachine;
import com.hollingsworth.arsnouveau.api.scrying.IScryer;
import com.hollingsworth.arsnouveau.api.scrying.SingleBlockScryer;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.ritual.RitualScrying;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.shynieke.georenouveau.entity.LinkedGeOre;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GeOreDowsingRod
extends ModItem {
    private final LinkedGeOre linkedGeOre;

    public GeOreDowsingRod(Item.Properties properties, LinkedGeOre linkedGeOre) {
        super(properties.durability(4));
        this.linkedGeOre = linkedGeOre;
        this.withTooltip((Component)Component.translatable((String)("tooltip.geore_nouveau." + linkedGeOre.getName() + "_dowsing_rod")));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        if (context.getLevel() instanceof ServerLevel && (blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof IPedestalMachine) {
            IPedestalMachine ipm = (IPedestalMachine)blockEntity;
            ipm.lightPedestal(context.getLevel());
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        heldStack.setDamageValue(player.getItemInHand(hand).getDamageValue() + 1);
        if (heldStack.getDamageValue() >= this.getMaxDamage(heldStack)) {
            heldStack.shrink(1);
        }
        if (!level.isClientSide) {
            player.addEffect(new MobEffectInstance(level.holderOrThrow(ModPotions.MAGIC_FIND_EFFECT.getKey()), 1200));
            SingleBlockScryer singleBlockScryer = new SingleBlockScryer(this.linkedGeOre.getBudding());
            RitualScrying.grantScrying((ServerPlayer)((ServerPlayer)player), (int)1200, (IScryer)singleBlockScryer);
        }
        return super.use(level, player, hand);
    }
}

