/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.item;

import com.hollingsworth.arsnouveau.api.item.AbstractSummonCharm;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.shynieke.georenouveau.entity.GeOreGolem;
import com.shynieke.georenouveau.entity.LinkedGeOre;
import com.shynieke.georenouveau.registry.CompatRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class GeOreGolemCharm
extends AbstractSummonCharm {
    private final LinkedGeOre linkedGeOre;

    public GeOreGolemCharm(Item.Properties properties, LinkedGeOre linkedGeOre) {
        super(properties);
        this.linkedGeOre = linkedGeOre;
        this.withTooltip((Component)Component.translatable((String)("tooltip.geore_nouveau." + linkedGeOre.getName() + "_charm")));
    }

    public InteractionResult useOnBlock(UseOnContext context, Level level, BlockPos pos) {
        GeOreGolem golem = new GeOreGolem(CompatRegistry.GEORE_GOLEM.get(), level);
        golem.fromCharmData((PersistentFamiliarData)context.getItemInHand().getOrDefault((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData()));
        golem.setPos(pos.getX(), pos.above().getY(), pos.getZ());
        golem.setLinkedGeOre(this.linkedGeOre);
        level.addFreshEntity((Entity)golem);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOnSummonTile(UseOnContext context, Level level, SummoningTile summoningTile, BlockPos pos) {
        return this.useOnBlock(context, level, pos);
    }
}

