/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SilverfishSkullModel
extends SkullModelBase {
    private final ModelPart root;
    private final ModelPart[] bodyParts = new ModelPart[3];
    private final ModelPart[] bodyLayers = new ModelPart[2];
    private static final int[][] BODY_SIZES = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
    private static final int[][] BODY_TEXS = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};

    public SilverfishSkullModel(ModelPart root) {
        this.root = root;
        Arrays.setAll(this.bodyParts, i -> root.getChild(SilverfishSkullModel.getSegmentName(i)));
        Arrays.setAll(this.bodyLayers, i -> root.getChild(SilverfishSkullModel.getLayerName(i)));
    }

    private static String getLayerName(int id) {
        return "layer" + id;
    }

    private static String getSegmentName(int id) {
        return "segment" + id;
    }

    public static MeshDefinition createSilverfishHead() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float[] afloat = new float[7];
        float f = -3.5f;
        for (int i = 0; i < 3; ++i) {
            partdefinition.addOrReplaceChild(SilverfishSkullModel.getSegmentName(i), CubeListBuilder.create().texOffs(BODY_TEXS[i][0], BODY_TEXS[i][1]).addBox((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f + 1.5f, (float)BODY_SIZES[i][0], (float)BODY_SIZES[i][1], (float)BODY_SIZES[i][2]), PartPose.offset((float)0.0f, (float)(24 - BODY_SIZES[i][1]), (float)f));
            afloat[i] = f;
            if (i >= 6) continue;
            f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
        }
        partdefinition.addOrReplaceChild(SilverfishSkullModel.getLayerName(0), CubeListBuilder.create().texOffs(20, 0).addBox(-5.0f, 0.0f, (float)BODY_SIZES[2][2] * -0.5f + 1.5f, 10.0f, 8.0f, (float)BODY_SIZES[2][2]), PartPose.offset((float)0.0f, (float)16.0f, (float)afloat[2]));
        partdefinition.addOrReplaceChild(SilverfishSkullModel.getLayerName(1), CubeListBuilder.create().texOffs(20, 11).addBox(-3.0f, 0.0f, (float)BODY_SIZES[4][2] * -0.5f + 1.5f, 6.0f, 4.0f, (float)BODY_SIZES[4][2]), PartPose.offset((float)0.0f, (float)20.0f, (float)afloat[4]));
        return meshdefinition;
    }

    public static LayerDefinition createSkullModel() {
        MeshDefinition meshdefinition = SilverfishSkullModel.createSilverfishHead();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        this.root.yRot = yRot * ((float)Math.PI / 180);
        this.root.xRot = xRot * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        poseStack.translate(0.0f, -1.5f, 0.0f);
        this.root.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
    }
}

