/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class SlimeSkullModel
extends SkullModelBase {
    private static final ResourceLocation SLIME_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/slime/slime.png");
    protected final ModelPart root;
    protected final ModelPart cube;
    protected final ModelPart cubeOuter;

    public SlimeSkullModel(ModelPart root) {
        this.root = root;
        this.cube = root.getChild("cube");
        this.cubeOuter = root.getChild("cube_outer");
    }

    public static MeshDefinition createSlimeModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cube = partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -7.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
        cube.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(32, 0).addBox(-3.25f, -6.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        cube.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(32, 4).addBox(1.25f, -6.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        cube.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(32, 8).addBox(0.0f, -3.0f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cube_outer", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createSkullModel() {
        MeshDefinition meshdefinition = SlimeSkullModel.createSlimeModel();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        this.cube.yRot = yRot * ((float)Math.PI / 180);
        this.cube.xRot = xRot * ((float)Math.PI / 180);
        this.cubeOuter.yRot = yRot * ((float)Math.PI / 180);
        this.cubeOuter.xRot = xRot * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        this.cube.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)SLIME_LOCATION);
        VertexConsumer slimeConsumer = bufferSource.getBuffer(renderType);
        this.cubeOuter.render(poseStack, slimeConsumer, packedLightIn, packedOverlayIn, color);
        bufferSource.endBatch(renderType);
    }
}

