/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.registry;

import com.mrbysco.heads.Heads;
import com.mrbysco.heads.block.HeadBlock;
import com.mrbysco.heads.block.WallHeadBlock;
import com.mrbysco.heads.registry.HeadTypes;
import com.mrbysco.heads.registry.HeadsRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class HeadReg {
    protected final String mobName;
    protected final String headName;
    protected final HeadTypes headType;
    protected final DeferredBlock<HeadBlock> HEAD;
    protected final DeferredBlock<WallHeadBlock> WALL_HEAD;
    protected final DeferredItem<StandingAndWallBlockItem> HEAD_ITEM;
    protected final DeferredHolder<SoundEvent, SoundEvent> IMITATE_SOUND;

    public String getMobName() {
        return this.mobName;
    }

    public String getHeadName() {
        return this.headName;
    }

    public DeferredBlock<HeadBlock> getHead() {
        return this.HEAD;
    }

    public DeferredBlock<WallHeadBlock> getWallHead() {
        return this.WALL_HEAD;
    }

    public DeferredItem<StandingAndWallBlockItem> getHeadItem() {
        return this.HEAD_ITEM;
    }

    public DeferredHolder<SoundEvent, SoundEvent> getImitateSound() {
        return this.IMITATE_SOUND;
    }

    public HeadReg(String mobName, String headName, String suffix, HeadTypes headType) {
        this.mobName = mobName;
        this.headName = headName;
        this.headType = headType;
        String soundLocation = "heads.block.note_block.imitate." + headName;
        this.IMITATE_SOUND = HeadsRegistry.SOUND_EVENTS.register(soundLocation, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Heads.modLoc(soundLocation)));
        this.HEAD = HeadsRegistry.BLOCKS.registerBlock(headName + "_" + suffix, properties -> new HeadBlock(headType, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ZOMBIE_HEAD).instrument(NoteBlockInstrument.CUSTOM_HEAD).strength(1.0f));
        this.WALL_HEAD = HeadsRegistry.BLOCKS.registerBlock(headName + "_wall_" + suffix, properties -> new WallHeadBlock(headType, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ZOMBIE_HEAD).instrument(NoteBlockInstrument.CUSTOM_HEAD).strength(1.0f).lootFrom(this.HEAD));
        this.HEAD_ITEM = HeadsRegistry.ITEMS.registerItem(headName + "_" + suffix, properties -> new StandingAndWallBlockItem((Block)this.HEAD.get(), (Block)this.WALL_HEAD.get(), properties.component(DataComponents.NOTE_BLOCK_SOUND, (Object)this.IMITATE_SOUND.getId()).rarity(Rarity.UNCOMMON), Direction.DOWN));
        HeadsRegistry.headList.add(this);
        HeadsRegistry.headMap.put(headType, this);
    }

    public HeadReg(String mobName, String suffix, HeadTypes headType) {
        this(mobName, mobName, suffix, headType);
    }
}

