/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.handler;

import com.mrbysco.horsingaround.HorsingAround;
import com.mrbysco.horsingaround.config.HorsingConfig;
import com.mrbysco.horsingaround.data.CallData;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class TameHandler {
    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        Entity entity;
        if (event.isMounting() && (entity = event.getEntityMounting()) instanceof Player) {
            OwnableEntity ownableEntity;
            Entity mountedEntity;
            Player player = (Player)entity;
            if (!player.level().isClientSide && ((Boolean)HorsingConfig.COMMON.addOnMount.get()).booleanValue() && (mountedEntity = event.getEntityBeingMounted()) instanceof OwnableEntity && (ownableEntity = (OwnableEntity)mountedEntity).getOwnerUUID() != null && ownableEntity.getOwnerUUID().equals(player.getUUID())) {
                CallData callData = CallData.get(player.level());
                callData.addTamedData(player.getUUID(), mountedEntity);
            }
        }
    }

    @SubscribeEvent
    public void onTameAnimal(AnimalTameEvent event) {
        Animal tamedAnimal;
        Player player = event.getTamer();
        if (event.getTamer() != null && !player.level().isClientSide && ((Boolean)HorsingConfig.COMMON.addOnTame.get()).booleanValue() && (tamedAnimal = event.getAnimal()) instanceof OwnableEntity) {
            CallData callData = CallData.get(player.level());
            callData.addTamedData(player.getUUID(), (Entity)tamedAnimal);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            OwnableEntity ownableEntity;
            Entity targetEntity = event.getTarget();
            ItemStack stack = event.getItemStack();
            if (stack.is(HorsingAround.LINKING) && event.getHand() == InteractionHand.MAIN_HAND && targetEntity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)targetEntity).getOwnerUUID() != null && ownableEntity.getOwnerUUID().equals(player.getUUID())) {
                CallData callData = CallData.get(player.level());
                callData.addTamedData(player.getUUID(), targetEntity);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        OwnableEntity ownableEntity;
        UUID ownerUUID;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (!livingEntity2.level().isClientSide && (livingEntity = event.getEntity()) instanceof OwnableEntity && (ownerUUID = (ownableEntity = (OwnableEntity)livingEntity).getOwnerUUID()) != null) {
            CallData callData = CallData.get(livingEntity2.level());
            callData.removeTamedData(ownerUUID, (Entity)livingEntity2);
        }
    }
}

