/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.network.handler;

import com.mrbysco.horsingaround.data.CallData;
import com.mrbysco.horsingaround.network.message.SummonPayload;
import com.mrbysco.horsingaround.network.message.UnlinkPayload;
import com.mrbysco.horsingaround.registry.HorsingRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSummon(SummonPayload summonData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerLevel level = serverPlayer.serverLevel();
                UUID mobUUID = summonData.mobUUID();
                Entity mob = level.getEntity(mobUUID);
                CallData callData = CallData.get(serverPlayer.level());
                if (mob == null) {
                    List<CallData.TamedData> tamedList = callData.getTamedData(serverPlayer.getUUID());
                    CallData.TamedData matchingData = null;
                    for (CallData.TamedData data : tamedList) {
                        if (!data.uuid().equals(mobUUID)) continue;
                        matchingData = data;
                        break;
                    }
                    if (matchingData != null) {
                        Entity entity = matchingData.createEntity(serverPlayer.level());
                        entity.setPos(serverPlayer.position());
                        level.addFreshEntity(entity);
                    }
                } else {
                    mob.teleportTo(serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ());
                    callData.updateData(mob.getUUID(), mob);
                }
                callData.syncData(serverPlayer.getUUID());
                level.playSound((Player)null, serverPlayer.blockPosition(), (SoundEvent)HorsingRegistry.CALL.get(), serverPlayer.getSoundSource(), 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"horsingaround.networking.summon.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleUnlink(UnlinkPayload unlinkData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player != null) {
                CallData callData = CallData.get(player.level());
                callData.removeTamedData(player.getUUID(), unlinkData.mobUUID());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"horsingaround.networking.unlink.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

