/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MetalPressRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<MetalPressRecipe>> SERIALIZER;
    public static final CachedRecipeList<MetalPressRecipe> STANDARD_RECIPES;
    private static final Map<ResourceLocation, MetalPressRecipe> SPECIAL_RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public IngredientWithSize input;
    public final Item mold;
    public final TagOutput output;
    private static ArrayListMultimap<Item, RecipeHolder<MetalPressRecipe>> recipesByMold;
    private static int reloadCountForByMold;

    public static synchronized void addSpecialRecipe(ResourceLocation rl, MetalPressRecipe recipe) {
        SPECIAL_RECIPES.put(rl, recipe);
    }

    public MetalPressRecipe(TagOutput output, IngredientWithSize input, Item mold, int energy) {
        super(output, IERecipeTypes.METAL_PRESS, 60, energy, MULTIPLIERS);
        this.output = output;
        this.input = input;
        this.mold = mold;
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.outputList = new TagOutputList(this.output);
    }

    protected IERecipeSerializer<MetalPressRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public MetalPressRecipe setInputSize(int size) {
        this.input = new IngredientWithSize(this.input.getBaseIngredient(), size);
        return this;
    }

    public boolean matches(ItemStack mold, ItemStack input, Level world) {
        return this.input.test(input);
    }

    public RecipeHolder<MetalPressRecipe> getActualRecipe(ResourceLocation ownId, ItemStack mold, ItemStack input, Level world) {
        return new RecipeHolder(ownId, (Recipe)this);
    }

    public static RecipeHolder<MetalPressRecipe> findRecipe(ItemStack mold, ItemStack input, Level world) {
        if (mold.isEmpty() || input.isEmpty()) {
            return null;
        }
        List list = MetalPressRecipe.getRecipesByMold(world).get((Object)mold.getItem());
        for (RecipeHolder recipe : list) {
            if (!((MetalPressRecipe)recipe.value()).matches(mold, input, world)) continue;
            return ((MetalPressRecipe)recipe.value()).getActualRecipe(recipe.id(), mold, input, world);
        }
        return null;
    }

    public static boolean isValidMold(Level level, ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        return MetalPressRecipe.getRecipesByMold(level).containsKey((Object)itemStack.getItem());
    }

    private static ArrayListMultimap<Item, RecipeHolder<MetalPressRecipe>> getRecipesByMold(Level level) {
        if (reloadCountForByMold != CachedRecipeList.getReloadCount()) {
            recipesByMold = ArrayListMultimap.create();
            BiConsumer<ResourceLocation, MetalPressRecipe> addToMap = (id, recipe) -> recipesByMold.put((Object)recipe.mold, (Object)new RecipeHolder(id, (Recipe)recipe));
            STANDARD_RECIPES.getRecipes(level).forEach(r -> addToMap.accept(r.id(), (MetalPressRecipe)r.value()));
            SPECIAL_RECIPES.forEach(addToMap);
            reloadCountForByMold = CachedRecipeList.getReloadCount();
        }
        return recipesByMold;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        STANDARD_RECIPES = new CachedRecipeList<MetalPressRecipe>(IERecipeTypes.METAL_PRESS);
        SPECIAL_RECIPES = new HashMap<ResourceLocation, MetalPressRecipe>();
        MULTIPLIERS = SetRestrictedField.common();
        recipesByMold = ArrayListMultimap.create();
        reloadCountForByMold = -1;
    }
}

