/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import blusunrize.immersiveengineering.common.blocks.metal.CrafterPatternInventory;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.AssemblerShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.InventoryCraftingFalse;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AssemblerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int NUM_PATTERNS = 3;
    public static final int NUM_TANKS = 3;
    public static final int TANK_CAPACITY = 8000;
    public static final int ENERGY_CAPACITY = 32000;
    public static final int INVENTORY_SIZE = 21;
    private static final CapabilityPosition ITEM_INPUT = new CapabilityPosition(1, 1, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(1, 0, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(1, 2, 1, RelativeBlockFace.UP);
    public static final BlockPos[] REDSTONE_PORTS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(2, 0, 1)};
    public static ResourceLocation[] MIF_CONDITION_TANKS;

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.shouldPlaySound, context.isValid(), soundPos, IESounds.assembler, 0.625f);
        }
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean wasPlaying = state.shouldPlaySound;
        if (!state.rsState.isEnabled(context) && wasPlaying != state.rsState.isEnabled(context)) {
            state.shouldPlaySound = false;
            context.requestMasterBESync();
        }
        if (!context.getLevel().shouldTickModulo(16) || !state.rsState.isEnabled(context)) {
            return;
        }
        List<OutputBuffer> outputs = this.craftRecipes(context);
        for (OutputBuffer buffer : outputs) {
            for (int i = 0; i < buffer.results.size(); ++i) {
                this.outputStack(state, (ItemStack)buffer.results.get(i), buffer.id, i == 0);
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient(state, state.inventory.getStackInSlot(18 + i), i)) continue;
            state.inventory.setStackInSlot(18 + i, Utils.insertStackIntoInventory(state.output, state.inventory.getStackInSlot(18 + i), false));
        }
        boolean bl = state.shouldPlaySound = state.rsState.isEnabled(context) && !outputs.isEmpty();
        if (wasPlaying != state.shouldPlaySound) {
            context.requestMasterBESync();
        }
    }

    private List<OutputBuffer> craftRecipes(IMultiblockContext<State> ctx) {
        State state = ctx.getState();
        ArrayList<OutputBuffer> outputBuffer = new ArrayList<OutputBuffer>();
        for (int patternId = 0; patternId < state.patterns.length; ++patternId) {
            CrafterPatternInventory pattern = state.patterns[patternId];
            ItemStack output = ((ItemStack)pattern.inv.get(9)).copy();
            if (output.isEmpty() || !this.canOutput(state, output, patternId)) continue;
            ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
            for (OutputBuffer bufferedStacks : outputBuffer) {
                availableStacks.addAll((Collection<ItemStack>)bufferedStacks.results);
            }
            for (ItemStack stack : state.inventory) {
                if (stack.isEmpty()) continue;
                availableStacks.add(stack);
            }
            List<RecipeQuery> queries = pattern.getQueries(ctx.getLevel().getRawLevel());
            if (queries == null) continue;
            int consumed = (Integer)IEServerConfig.MACHINES.assembler_consumption.get();
            if (!this.consumeIngredients(state, queries, availableStacks, false, null) || state.energy.extractEnergy(consumed, false) != consumed) continue;
            NonNullList outputList = NonNullList.create();
            outputList.add((Object)output);
            RecipeInputSources sources = new RecipeInputSources(pattern);
            this.consumeIngredients(state, queries, availableStacks, true, sources);
            NonNullList remainingItems = pattern.recipe.getRemainingItems((RecipeInput)InventoryCraftingFalse.createFilledCraftingInventory(3, 3, sources.gridItems));
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack rem = (ItemStack)remainingItems.get(i);
                if (sources.providedByNonItem.getBoolean(i) || rem.isEmpty()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer.add(new OutputBuffer((NonNullList<ItemStack>)outputList, patternId));
            ctx.markMasterDirty();
        }
        return outputBuffer;
    }

    private void outputStack(State state, ItemStack output, int patternId, boolean isMainOutput) {
        if (!this.isRecipeIngredient(state, output, patternId) && ((output = Utils.insertStackIntoInventory(state.output, output, false)).isEmpty() || output.getCount() <= 0)) {
            return;
        }
        if (isMainOutput) {
            this.tryInsertOnto(state, 18 + patternId, output);
        } else {
            int i;
            boolean inserted = false;
            for (i = 0; i < state.inventory.getSlots(); ++i) {
                if (!this.tryInsertOnto(state, i, output)) continue;
                inserted = true;
                break;
            }
            if (!inserted) {
                for (i = 0; i < state.inventory.getSlots(); ++i) {
                    if (!state.inventory.getStackInSlot(i).isEmpty()) continue;
                    state.inventory.setStackInSlot(i, output.copy());
                }
            }
        }
    }

    public boolean consumeIngredients(State state, List<RecipeQuery> queries, ArrayList<ItemStack> itemStacks, boolean doConsume, @Nullable RecipeInputSources sources) {
        if (!doConsume) {
            ArrayList<ItemStack> dupeList = new ArrayList<ItemStack>(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                dupeList.add(itemStack.copy());
            }
            itemStacks = dupeList;
        }
        List<FluidStack> tankFluids = Arrays.stream(state.tanks).map(tank -> doConsume ? tank.getFluid() : tank.getFluid().copy()).toList();
        for (int i = 0; i < queries.size(); ++i) {
            RecipeQuery recipeQuery = queries.get(i);
            int querySize = recipeQuery.getItemCount();
            if (recipeQuery.isFluid()) {
                if (this.consumeFluid(tankFluids, i, recipeQuery, sources)) continue;
                querySize = 1;
            }
            for (ItemStack itemStack : itemStacks) {
                querySize -= this.consumeItem(querySize, i, itemStack, recipeQuery, sources);
            }
            if (querySize <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isRecipeIngredient(State state, ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return false;
        }
        if (slot - 1 < state.patterns.length || state.recursiveIngredients) {
            int p;
            int n = p = state.recursiveIngredients ? 0 : slot;
            while (p < state.patterns.length) {
                CrafterPatternInventory pattern = state.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).isEmpty() || !ItemStack.isSameItem((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack)) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    private boolean consumeFluid(List<FluidStack> tankFluids, int queryIndex, RecipeQuery query, @Nullable RecipeInputSources sources) {
        for (FluidStack tankFluid : tankFluids) {
            if (!query.matchesFluid(tankFluid)) continue;
            tankFluid.shrink(query.getFluidSize());
            if (sources != null) {
                sources.providedByNonItem.set(sources.getSlotForQueryIndex(queryIndex), true);
            }
            return true;
        }
        return false;
    }

    private int consumeItem(int maxConsume, int queryIndex, ItemStack next, RecipeQuery query, @Nullable RecipeInputSources sources) {
        if (maxConsume <= 0 || next.isEmpty() || !query.matchesIgnoringSize(next)) {
            return 0;
        }
        int taken = Math.min(maxConsume, next.getCount());
        ItemStack forGrid = next.split(taken);
        if (sources != null) {
            sources.gridItems.set(sources.getSlotForQueryIndex(queryIndex), forGrid);
        }
        return taken;
    }

    private boolean tryInsertOnto(State state, int slot, ItemStack toAdd) {
        if (!this.canInsertOnto(state, slot, toAdd)) {
            return false;
        }
        ItemStack present = state.inventory.getStackInSlot(slot);
        if (present.isEmpty()) {
            state.inventory.setStackInSlot(slot, toAdd);
        } else {
            present.grow(toAdd.getCount());
        }
        return true;
    }

    public boolean canInsertOnto(State state, int slot, ItemStack output) {
        ItemStack existing = state.inventory.getStackInSlot(slot);
        if (existing.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)existing)) {
            return false;
        }
        return existing.getCount() + output.getCount() <= existing.getMaxStackSize();
    }

    public boolean canOutput(State state, ItemStack output, int iPattern) {
        return this.canInsertOnto(state, 18 + iPattern, output);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAt(Capabilities.ItemHandler.BLOCK, ITEM_INPUT, state -> state.itemInput);
        register.registerAt(Capabilities.FluidHandler.BLOCK, FLUID_INPUT, state -> state.fluidInput);
        register.registerAt(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
        for (BlockPos bp : REDSTONE_PORTS) {
            register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, bp, state -> state.mifHandler);
        }
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return AssemblerShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(ComparatorManager.SimpleComparatorValue.inventory(State::getInventory, 0, 18), REDSTONE_PORTS);
    }

    static {
        for (ResourceLocation tank_cond : MIF_CONDITION_TANKS = (ResourceLocation[])IntStream.range(0, 3).mapToObj(i -> IEApi.ieLoc("assembler/tank_" + i)).toArray(ResourceLocation[]::new)) {
            MachineInterfaceHandler.copyOptions(tank_cond, MachineInterfaceHandler.BASIC_FLUID_IN);
        }
    }

    public static class State
    implements IMultiblockState {
        public final FluidTank[] tanks = (FluidTank[])IntStream.range(0, 3).mapToObj($ -> new FluidTank(8000)).toArray(FluidTank[]::new);
        public final SlotwiseItemHandler inventory;
        public final CrafterPatternInventory[] patterns = (CrafterPatternInventory[])IntStream.range(0, 3).mapToObj($ -> new CrafterPatternInventory()).toArray(CrafterPatternInventory[]::new);
        public boolean recursiveIngredients = false;
        public final MutableEnergyStorage energy = new MutableEnergyStorage(32000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final Supplier<@Nullable IItemHandler> output;
        private final IItemHandler itemInput;
        private final IFluidHandler fluidInput;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        private BooleanSupplier isPlayingSound = () -> false;
        private boolean shouldPlaySound;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, new BlockPos(1, 1, -1), RelativeBlockFace.FRONT);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 21)), ctx.getMarkDirtyRunnable());
            this.itemInput = new WrappingItemHandler((IItemHandler)this.inventory, true, false);
            this.fluidInput = new ArrayFluidHandler((IFluidTank[])this.tanks, false, true, ctx.getMarkDirtyRunnable());
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.itemInput, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation<FluidTank>(this.tanks[0], MIF_CONDITION_TANKS[0]), new MachineInterfaceHandler.MachineCheckImplementation<FluidTank>(this.tanks[1], MIF_CONDITION_TANKS[1]), new MachineInterfaceHandler.MachineCheckImplementation<FluidTank>(this.tanks[2], MIF_CONDITION_TANKS[2]), new MachineInterfaceHandler.MachineCheckImplementation<Supplier<IItemHandler>>(this.output, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation<MutableEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            ListTag tanks = new ListTag();
            for (FluidTank tank : this.tanks) {
                tanks.add((Object)tank.writeToNBT(provider, new CompoundTag()));
            }
            ListTag patterns = new ListTag();
            for (CrafterPatternInventory pattern : this.patterns) {
                patterns.add((Object)pattern.writeToNBT(provider));
            }
            nbt.put("tanks", (Tag)tanks);
            nbt.put("patterns", (Tag)patterns);
            nbt.putBoolean("recursiveIngredients", this.recursiveIngredients);
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("energy", this.energy.serializeNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            ListTag tanks = nbt.getList("tanks", 10);
            for (int i = 0; i < 3; ++i) {
                this.tanks[i].readFromNBT(provider, tanks.getCompound(i));
            }
            ListTag patterns = nbt.getList("patterns", 9);
            for (int i = 0; i < 3; ++i) {
                this.patterns[i].readFromNBT(patterns.getList(i), provider);
            }
            this.recursiveIngredients = nbt.getBoolean("recursiveIngredients");
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.energy.deserializeNBT(provider, nbt.get("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("shouldPlaySound", this.shouldPlaySound);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.shouldPlaySound = nbt.getBoolean("shouldPlaySound");
        }

        public IItemHandler getInventory() {
            return this.inventory;
        }
    }

    private record OutputBuffer(NonNullList<ItemStack> results, int id) {
    }

    private record RecipeInputSources(List<ItemStack> gridItems, BooleanList providedByNonItem) {
        public RecipeInputSources(CrafterPatternInventory pattern) {
            this(new ArrayList<ItemStack>((Collection<ItemStack>)pattern.inv), (BooleanList)new BooleanArrayList(new boolean[9]));
        }

        public int getSlotForQueryIndex(int queryIdx) {
            for (int slot = 0; slot < this.gridItems.size(); ++slot) {
                if (this.gridItems.get(slot).isEmpty() || --queryIdx >= 0) continue;
                return slot;
            }
            return 0;
        }
    }
}

