/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.client.render.tooltip.RevolverServerTooltip;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.ListUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class SpeedloaderItem
extends InternalStorageItem
implements IEItemInterfaces.IBulletContainer {
    public SpeedloaderItem() {
        super(new Item.Properties().stacksTo(1), 8);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            this.openGui(player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return IEMenuTypes.REVOLVER;
    }

    public boolean isEmpty(ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv == null) {
            return true;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack b = inv.getStackInSlot(i);
            if (b.isEmpty() || !(b.getItem() instanceof BulletItem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBulletCount(ItemStack container) {
        return this.getSlotCount();
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromStream(SpeedloaderItem.getContainedItems(revolver).stream(), this.getSlotCount());
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack pStack) {
        return Optional.of(new RevolverServerTooltip(this.getBullets(pStack), this.getBulletCount(pStack)));
    }
}

