/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialPredicate
implements Predicate<IMaterial> {
    public final boolean defaultValue;
    public final Object2BooleanMap<MaterialType> materialTypes;
    public final Object2BooleanMap<IMaterial> materials;
    public final String path;
    public final String comment;
    public final Object2BooleanMap<IMaterial> configMaterials;

    private MaterialPredicate(boolean defaultValue, Object2BooleanMap<MaterialType> materialTypes, Object2BooleanMap<IMaterial> materials, String path, String comment) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
        this.path = Strings.nullToEmpty((String)path);
        this.comment = Strings.nullToEmpty((String)comment);
        this.configMaterials = !path.isEmpty() ? new Object2BooleanOpenHashMap() : Object2BooleanMaps.emptyMap();
    }

    public static MaterialPredicate of(boolean defaultValue, Object2BooleanMap<MaterialType> materialTypes, Object2BooleanMap<IMaterial> materials, String path, String comment) {
        return new MaterialPredicate(defaultValue, materialTypes, materials, path, comment);
    }

    public static MaterialPredicate of(boolean defaultValue, Object2BooleanMap<MaterialType> materialTypes, Object2BooleanMap<IMaterial> materials) {
        return MaterialPredicate.of(defaultValue, materialTypes, materials, "", "");
    }

    public static MaterialPredicate of(boolean defaultValue, String path, String comment) {
        return MaterialPredicate.of(defaultValue, (Object2BooleanMap<MaterialType>)Object2BooleanMaps.emptyMap(), (Object2BooleanMap<IMaterial>)Object2BooleanMaps.emptyMap(), path, comment);
    }

    public static MaterialPredicate of(boolean defaultValue) {
        return MaterialPredicate.of(defaultValue, (Object2BooleanMap<MaterialType>)Object2BooleanMaps.emptyMap(), (Object2BooleanMap<IMaterial>)Object2BooleanMaps.emptyMap(), "", "");
    }

    public static MaterialPredicate of(boolean defaultValue, Predicate<IMaterial> function) {
        if (function instanceof MaterialPredicate) {
            MaterialPredicate mf = (MaterialPredicate)function;
            return MaterialPredicate.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        Object2BooleanMap materialMap = (Object2BooleanMap)JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::test, (a, b) -> a, Object2BooleanOpenHashMap::new));
        return MaterialPredicate.of(defaultValue, (Object2BooleanMap<MaterialType>)Object2BooleanMaps.emptyMap(), (Object2BooleanMap<IMaterial>)materialMap, "", "");
    }

    @Override
    public boolean test(IMaterial material) {
        if (!this.path.isEmpty()) {
            return this.configMaterials.computeIfAbsent((Object)material, m -> JAOPCAApi.instance().getMaterialConfig(material).getDefinedBoolean(this.path, this.testUnconfigured(material), this.comment));
        }
        return this.testUnconfigured(material);
    }

    public boolean testUnconfigured(IMaterial material) {
        if (this.materials.containsKey((Object)material)) {
            return this.materials.getBoolean((Object)material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.getBoolean((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials, this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialPredicate) {
            MaterialPredicate other = (MaterialPredicate)obj;
            return this.defaultValue == other.defaultValue && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials) && this.path.equals(other.path);
        }
        return false;
    }
}

