/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"create@[6.0.6,)"})
public class CreateNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("coal", "diamond", "emerald", "lapis", "quartz", "redstone"));

    @Override
    public String getName() {
        return "create_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        CreateHelper helper = CreateHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        ResourceLocation deepslateOreLocation = ResourceLocation.parse((String)"forge:ores_in_ground/deepslate");
        ResourceLocation netherrackOreLocation = ResourceLocation.parse((String)"forge:ores_in_ground/netherrack");
        ResourceLocation endstoneOreLocation = ResourceLocation.parse((String)"forge:ores_in_ground/end_stone");
        Item xpNugget = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:experience_nugget"));
        Item cobbledDeepslate = Items.COBBLED_DEEPSLATE;
        Item netherrack = Items.NETHERRACK;
        Item endstone = Items.END_STONE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = ((JAOPCAApi)api).getMaterialConfig(material);
            String configByproduct = config.getDefinedString("create.byproduct", "minecraft:cobblestone", s -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)s)), "The default byproduct material to output in Create's crushing.");
            Item byproduct = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)configByproduct));
            boolean isCrystal = material.getType() != MaterialType.DUST;
            helper.registerCrushingRecipe(miscHelper.getRecipeKey("create.default_ore_to_material", material.getName()), CompoundIngredientObject.difference(oreLocation, deepslateOreLocation, netherrackOreLocation, endstoneOreLocation), isCrystal ? 350 : 250, materialLocation, isCrystal ? 1 : 3, materialLocation, 1, Float.valueOf(isCrystal ? 0.75f : 0.5f), xpNugget, 1, Float.valueOf(0.75f), byproduct, 1, Float.valueOf(0.125f));
            helper.registerCrushingRecipe(miscHelper.getRecipeKey("create.deepslate_ore_to_material", material.getName()), CompoundIngredientObject.intersection(oreLocation, deepslateOreLocation), isCrystal ? 450 : 350, materialLocation, isCrystal ? 2 : 4, materialLocation, 1, Float.valueOf(isCrystal ? 0.25f : 0.5f), xpNugget, 1, Float.valueOf(0.75f), cobbledDeepslate, 1, Float.valueOf(0.125f));
            helper.registerCrushingRecipe(miscHelper.getRecipeKey("create.netherrack_ore_to_material", material.getName()), CompoundIngredientObject.intersection(oreLocation, netherrackOreLocation), isCrystal ? 450 : 350, materialLocation, isCrystal ? 1 : 3, materialLocation, 1, Float.valueOf(isCrystal ? 0.75f : 0.5f), xpNugget, 1, Float.valueOf(0.75f), netherrack, 1, Float.valueOf(0.125f));
            if (!itemTags.contains(endstoneOreLocation)) continue;
            helper.registerCrushingRecipe(miscHelper.getRecipeKey("create.end_stone_ore_to_material", material.getName()), CompoundIngredientObject.intersection(oreLocation, endstoneOreLocation), isCrystal ? 450 : 350, materialLocation, isCrystal ? 1 : 3, materialLocation, 1, Float.valueOf(isCrystal ? 0.75f : 0.5f), xpNugget, 1, Float.valueOf(0.75f), endstone, 1, Float.valueOf(0.125f));
        }
    }

    static {
        if (ModList.get().isLoaded("appliedenergistics2")) {
            Collections.addAll(BLACKLIST, "certus", "charged_certus");
        }
        if (ModList.get().isLoaded("druidcraft")) {
            Collections.addAll(BLACKLIST, "amber", "fiery_glass", "moonstone");
        }
        if (ModList.get().isLoaded("silentgems")) {
            Collections.addAll(BLACKLIST, "agate", "alexandrite", "amazonite", "amber", "amethyst", "ametrine", "ammolite", "apatite", "aquamarine", "benitoite", "black_diamond", "carnelian", "cats_eye", "chrysoprase", "citrine", "coral", "euclase", "fluorite", "garnet", "green_sapphire", "heliodor", "iolite", "jade", "jasper", "kunzite", "kyanite", "lepidoite", "malachite", "moldavite", "moonstone", "morganite", "onyx", "opal", "pearl", "peridot", "phosphophyllite", "pyrope", "rose_quartz", "ruby", "sapphire", "sodalite", "spinel", "sunstone", "tanzanite", "teklite", "topaz", "turquoise", "yellow_diamond", "zircon");
        }
        if (ModList.get().isLoaded("thermal")) {
            Collections.addAll(BLACKLIST, "apatite", "cinnabar", "niter", "sulfur");
        }
    }
}

