/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.electrodynamics.recipes.ChemicalCrystallizerRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.ChemicalReactorRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.ElectrolosisChamberRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.LatheRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.MineralCrusherRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.MineralGrinderRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.recipes.MineralWasherRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.registers.VoltaicGases;

public class ElectrodynamicsHelper {
    public static final ElectrodynamicsHelper INSTANCE = new ElectrodynamicsHelper();
    private static final Logger LOGGER = LogManager.getLogger();

    private ElectrodynamicsHelper() {
    }

    public CountableIngredient getCountableIngredient(Object obj, int count) {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(obj);
        return ing == null ? null : new CountableIngredient(ing, count);
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj, int amount) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Supplier.class, FluidIngredient.class, String.class, ResourceLocation.class, TagKey.class, FluidStack.class, FluidStack[].class, Holder.class, Holder[].class, Fluid.class, Fluid[].class, IFluidLike.class, IFluidLike[].class, JsonElement.class}, (Object)object2, n)) {
            case 0: {
                Supplier supplier = (Supplier)object2;
                Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(supplier.get(), amount);
                ing = (FluidIngredient)pair.getLeft();
                fluids.addAll((Collection)pair.getRight());
                break;
            }
            case 1: {
                FluidIngredient fluidIng;
                ing = fluidIng = (FluidIngredient)object2;
                BuiltInRegistries.FLUID.forEach(fluids::add);
                break;
            }
            case 2: {
                String str = (String)object2;
                ResourceLocation location = ResourceLocation.parse((String)str);
                ing = new FluidIngredient(helper.getFluidTagKey(location), amount);
                fluids.addAll(helper.getFluidTagValues(location));
                break;
            }
            case 3: {
                ResourceLocation location = (ResourceLocation)object2;
                ing = new FluidIngredient(helper.getFluidTagKey(location), amount);
                fluids.addAll(helper.getFluidTagValues(location));
                break;
            }
            case 4: {
                TagKey key = (TagKey)object2;
                ing = new FluidIngredient(helper.getFluidTagKey(key.location()), amount);
                fluids.addAll(helper.getFluidTagValues(key.location()));
                break;
            }
            case 5: {
                FluidStack stack = (FluidStack)object2;
                if (stack.isEmpty()) break;
                ing = new FluidIngredient(stack);
                fluids.add(stack.getFluid());
                break;
            }
            case 6: {
                FluidStack[] stacks = (FluidStack[])object2;
                List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new FluidIngredient(nonEmpty);
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
                break;
            }
            case 7: {
                Fluid fluid;
                Object object3;
                Holder holder = (Holder)object2;
                if (!holder.isBound() || !((object3 = holder.value()) instanceof Fluid) || (fluid = (Fluid)object3) == Fluids.EMPTY) break;
                ing = new FluidIngredient(fluid, amount);
                fluids.add(fluid);
                break;
            }
            case 8: {
                Holder[] holders = (Holder[])object2;
                List<FluidStack> nonEmpty = Arrays.stream(holders).filter(Holder::isBound).map(Holder::value).filter(Fluid.class::isInstance).map(Fluid.class::cast).filter(f -> f != Fluids.EMPTY).map(f -> new FluidStack(f, amount)).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new FluidIngredient(nonEmpty);
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
                break;
            }
            case 9: {
                Fluid fluid = (Fluid)object2;
                if (fluid == Fluids.EMPTY) break;
                ing = new FluidIngredient(fluid, amount);
                fluids.add(fluid);
                break;
            }
            case 10: {
                Fluid[] fluidz = (Fluid[])object2;
                List<FluidStack> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.EMPTY).map(f -> new FluidStack(f, amount)).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new FluidIngredient(nonEmpty);
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
                break;
            }
            case 11: {
                IFluidLike fluid = (IFluidLike)object2;
                if (fluid.asFluid() == Fluids.EMPTY) break;
                ing = new FluidIngredient(fluid.asFluid(), amount);
                fluids.add(fluid.asFluid());
                break;
            }
            case 12: {
                IFluidLike[] fluidz = (IFluidLike[])object2;
                List<FluidStack> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.EMPTY).map(f -> new FluidStack(f, amount)).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new FluidIngredient(nonEmpty);
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
                break;
            }
            case 13: {
                JsonElement json = (JsonElement)object2;
                ing = FluidIngredient.CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).orElse(null);
                BuiltInRegistries.FLUID.forEach(fluids::add);
                break;
            }
        }
        fluids.remove(Fluids.EMPTY);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public GasStack getGasStack(Object obj, int amount, int temperature, int pressure) {
        GasStack ret = this.getPreferredGasStack((Iterable)this.getGasIngredientResolved(obj, amount, temperature, pressure).getRight(), amount, temperature, pressure);
        return ret.isEmpty() ? GasStack.EMPTY : ret;
    }

    public GasIngredient getGasIngredient(Object obj, int amount, int temperature, int pressure) {
        return (GasIngredient)this.getGasIngredientResolved(obj, amount, temperature, pressure).getLeft();
    }

    public Pair<GasIngredient, Set<Gas>> getGasIngredientResolved(Object obj, int amount, int temperature, int pressure) {
        GasIngredient ing = null;
        HashSet<Gas> gases = new HashSet<Gas>();
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Supplier.class, GasIngredient.class, String.class, ResourceLocation.class, TagKey.class, GasStack.class, GasStack[].class, Holder.class, Holder[].class, Gas.class, Gas[].class, JsonElement.class}, (Object)object2, n)) {
            case 0: {
                Supplier supplier = (Supplier)object2;
                Pair<GasIngredient, Set<Gas>> pair = this.getGasIngredientResolved(supplier.get(), amount, temperature, pressure);
                ing = (GasIngredient)pair.getLeft();
                gases.addAll((Collection)pair.getRight());
                break;
            }
            case 1: {
                GasIngredient gasIng;
                ing = gasIng = (GasIngredient)object2;
                VoltaicGases.GAS_REGISTRY.forEach(gases::add);
                break;
            }
            case 2: {
                String str = (String)object2;
                ResourceLocation location = ResourceLocation.parse((String)str);
                ing = new GasIngredient(this.getGasTagKey(location), amount, temperature, pressure);
                gases.addAll(this.getGasTagValues(location));
                break;
            }
            case 3: {
                ResourceLocation location = (ResourceLocation)object2;
                ing = new GasIngredient(this.getGasTagKey(location), amount, temperature, pressure);
                gases.addAll(this.getGasTagValues(location));
                break;
            }
            case 4: {
                TagKey key = (TagKey)object2;
                ing = new GasIngredient(this.getGasTagKey(key.location()), amount, temperature, pressure);
                gases.addAll(this.getGasTagValues(key.location()));
                break;
            }
            case 5: {
                GasStack stack = (GasStack)object2;
                if (stack.isEmpty()) break;
                ing = new GasIngredient(stack);
                gases.add(stack.getGas());
                break;
            }
            case 6: {
                GasStack[] stacks = (GasStack[])object2;
                List<GasStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new GasIngredient(nonEmpty);
                nonEmpty.stream().map(GasStack::getGas).forEach(gases::add);
                break;
            }
            case 7: {
                Gas gas;
                Object object3;
                Holder holder = (Holder)object2;
                if (!holder.isBound() || !((object3 = holder.value()) instanceof Gas) || (gas = (Gas)object3).isEmpty()) break;
                ing = new GasIngredient(gas, amount, temperature, pressure);
                gases.add(gas);
                break;
            }
            case 8: {
                Holder[] holders = (Holder[])object2;
                List<GasStack> nonEmpty = Arrays.stream(holders).filter(Holder::isBound).map(Holder::value).filter(Gas.class::isInstance).map(Gas.class::cast).filter(g -> !g.isEmpty()).map(g -> new GasStack(g, amount, temperature, pressure)).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new GasIngredient(nonEmpty);
                nonEmpty.stream().map(GasStack::getGas).forEach(gases::add);
                break;
            }
            case 9: {
                Gas gas = (Gas)object2;
                if (gas.isEmpty()) break;
                ing = new GasIngredient(gas, amount, temperature, pressure);
                gases.add(gas);
                break;
            }
            case 10: {
                Gas[] gasez = (Gas[])object2;
                List<GasStack> nonEmpty = Arrays.stream(gasez).filter(g -> !g.isEmpty()).map(g -> new GasStack(g, amount, temperature, pressure)).toList();
                if (nonEmpty.isEmpty()) break;
                ing = new GasIngredient(nonEmpty);
                nonEmpty.stream().map(GasStack::getGas).forEach(gases::add);
                break;
            }
            case 11: {
                JsonElement json = (JsonElement)object2;
                ing = GasIngredient.CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).orElse(null);
                VoltaicGases.GAS_REGISTRY.forEach(gases::add);
                break;
            }
        }
        gases.remove(VoltaicGases.EMPTY.get());
        return Pair.of((Object)(gases.isEmpty() ? null : ing), gases);
    }

    public TagKey<Gas> getGasTagKey(ResourceLocation location) {
        return TagKey.create((ResourceKey)VoltaicGases.GAS_REGISTRY_KEY, (ResourceLocation)location);
    }

    public Collection<Gas> getGasTagValues(ResourceLocation location) {
        return MiscHelper.INSTANCE.getTagValues(VoltaicGases.GAS_REGISTRY_KEY, location);
    }

    public GasStack getPreferredGasStack(Iterable<Gas> collection, int amount, int temperature, int pressure) {
        return new GasStack(MiscHelper.INSTANCE.getPreferredEntry(arg_0 -> ((Registry)VoltaicGases.GAS_REGISTRY).getKey(arg_0), collection).orElse((Gas)VoltaicGases.EMPTY.get()), amount, temperature, pressure);
    }

    public boolean registerMineralCrusherRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralCrusherRecipeSerializer(key, group, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerMineralCrusherRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralCrusherRecipeSerializer(key, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerMineralCrusherRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralCrusherRecipeSerializer(key, group, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerMineralCrusherRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralCrusherRecipeSerializer(key, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerMineralGrinderRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralGrinderRecipeSerializer(key, group, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerMineralGrinderRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralGrinderRecipeSerializer(key, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerMineralGrinderRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralGrinderRecipeSerializer(key, group, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerMineralGrinderRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralGrinderRecipeSerializer(key, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerLatheRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LatheRecipeSerializer(key, group, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerLatheRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LatheRecipeSerializer(key, input, inputCount, output, outputCount, secondOutput, secondOutputCount, secondChance, experience, time, energy));
    }

    public boolean registerLatheRecipe(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LatheRecipeSerializer(key, group, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerLatheRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LatheRecipeSerializer(key, input, inputCount, output, outputCount, experience, time, energy));
    }

    public boolean registerChemicalCrystallizerRecipe(ResourceLocation key, String group, Object input, int inputAmount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalCrystallizerRecipeSerializer(key, group, input, inputAmount, output, outputCount, experience, time, energy));
    }

    public boolean registerChemicalCrystallizerRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalCrystallizerRecipeSerializer(key, input, inputAmount, output, outputCount, experience, time, energy));
    }

    public boolean registerChemicalReactorRecipe(ResourceLocation key, String group, Object[] itemInput, Object[] fluidInput, Object[] gasInput, Object[] itemOutput, Object[] fluidOutput, Object[] gasOutput, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalReactorRecipeSerializer(key, group, itemInput, fluidInput, gasInput, itemOutput, fluidOutput, gasOutput, experience, time, energy));
    }

    public boolean registerChemicalReactorRecipe(ResourceLocation key, Object[] itemInput, Object[] fluidInput, Object[] gasInput, Object[] itemOutput, Object[] fluidOutput, Object[] gasOutput, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalReactorRecipeSerializer(key, itemInput, fluidInput, gasInput, itemOutput, fluidOutput, gasOutput, experience, time, energy));
    }

    public boolean registerMineralWasherRecipe(ResourceLocation key, String group, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralWasherRecipeSerializer(key, group, itemInput, itemInputCount, fluidInput, fluidInputAmount, output, outputAmount, experience, time, energy));
    }

    public boolean registerMineralWasherRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MineralWasherRecipeSerializer(key, itemInput, itemInputCount, fluidInput, fluidInputAmount, output, outputAmount, experience, time, energy));
    }

    public boolean registerElectrolosisChamberRecipe(ResourceLocation key, String group, Object input, int inputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ElectrolosisChamberRecipeSerializer(key, group, input, inputAmount, output, outputAmount, experience, time, energy));
    }

    public boolean registerElectrolosisChamberRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ElectrolosisChamberRecipeSerializer(key, input, inputAmount, output, outputAmount, experience, time, energy));
    }
}

