/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"electrodynamics@[0.10.1,)"})
public class ElectrodynamicsNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("coal", "diamond", "emerald", "lapis", "niter", "potassiumchloride", "redstone", "salt", "sulfur"));

    @Override
    public String getName() {
        return "electrodynamics_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ElectrodynamicsHelper helper = ElectrodynamicsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            boolean isCrystal = material.getType() != MaterialType.DUST;
            helper.registerMineralGrinderRecipe(miscHelper.getRecipeKey("electrodynamics.ore_to_material_grinder", material.getName()), oreLocation, 1, materialLocation, isCrystal ? 3 : 2, isCrystal ? 1.0 : 0.2, 200, 350.0);
            if (isCrystal) continue;
            helper.registerMineralCrusherRecipe(miscHelper.getRecipeKey("electrodynamics.ore_to_material_crusher", material.getName()), oreLocation, 1, materialLocation, 4, 0.1, 200, 450.0);
        }
    }
}

