/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import electrodynamics.common.recipe.categories.fluid2item.specificmachines.ChemicalCrystalizerRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;
import voltaic.common.recipe.recipeutils.FluidIngredient;

public class ChemicalCrystallizerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final double experience;
    public final int time;
    public final double energy;

    public ChemicalCrystallizerRecipeSerializer(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double experience, int time, double energy) {
        this(key, "", input, inputAmount, output, outputCount, experience, time, energy);
    }

    public ChemicalCrystallizerRecipeSerializer(ResourceLocation key, String group, Object input, int inputAmount, Object output, int outputCount, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        FluidIngredient ing = ElectrodynamicsHelper.INSTANCE.getFluidIngredient(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ChemicalCrystalizerRecipe recipe = new ChemicalCrystalizerRecipe(this.group, List.of(ing), stack, this.experience, this.time, this.energy, List.of(), List.of(), List.of());
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

