/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import electrodynamics.common.recipe.categories.chemicalreactor.ChemicalReactorRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;

public class ChemicalReactorRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object[] itemInput;
    public final Object[] fluidInput;
    public final Object[] gasInput;
    public final Object[] itemOutput;
    public final Object[] fluidOutput;
    public final Object[] gasOutput;
    public final double experience;
    public final int time;
    public final double energy;

    public ChemicalReactorRecipeSerializer(ResourceLocation key, Object[] itemInput, Object[] fluidInput, Object[] gasInput, Object[] itemOutput, Object[] fluidOutput, Object[] gasOutput, double experience, int time, double energy) {
        this(key, "", itemInput, fluidInput, gasInput, itemOutput, fluidOutput, gasOutput, experience, time, energy);
    }

    public ChemicalReactorRecipeSerializer(ResourceLocation key, String group, Object[] itemInput, Object[] fluidInput, Object[] gasInput, Object[] itemOutput, Object[] fluidOutput, Object[] gasOutput, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.gasInput = gasInput;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.gasOutput = gasOutput;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        ArrayList<CountableIngredient> itemIngs = new ArrayList<CountableIngredient>();
        int i = 0;
        while (i < this.itemInput.length) {
            CountableIngredient ing;
            Object in = this.itemInput[i];
            Integer count = 1;
            if (++i < this.itemInput.length && this.itemInput[i] instanceof Integer) {
                count = (Integer)this.itemInput[i];
                ++i;
            }
            if ((ing = ElectrodynamicsHelper.INSTANCE.getCountableIngredient(in, count)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            itemIngs.add(ing);
        }
        ArrayList<FluidIngredient> fluidIngs = new ArrayList<FluidIngredient>();
        i = 0;
        while (i < this.fluidInput.length) {
            FluidIngredient ing;
            Object in = this.fluidInput[i];
            Integer amount = 1000;
            if (++i < this.fluidInput.length && this.fluidInput[i] instanceof Integer) {
                amount = (Integer)this.fluidInput[i];
                ++i;
            }
            if ((ing = ElectrodynamicsHelper.INSTANCE.getFluidIngredient(in, amount)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            fluidIngs.add(ing);
        }
        ArrayList<GasIngredient> gasIngs = new ArrayList<GasIngredient>();
        i = 0;
        while (i < this.gasInput.length) {
            GasIngredient ing;
            Object in = this.gasInput[i];
            Integer amount = 1000;
            if (++i < this.gasInput.length && this.gasInput[i] instanceof Integer) {
                amount = (Integer)this.gasInput[i];
                ++i;
            }
            Integer temperature = 293;
            if (i < this.gasInput.length && this.gasInput[i] instanceof Integer) {
                temperature = (Integer)this.gasInput[i];
                ++i;
            }
            Integer pressure = 1;
            if (i < this.gasInput.length && this.gasInput[i] instanceof Integer) {
                pressure = (Integer)this.gasInput[i];
                ++i;
            }
            if ((ing = ElectrodynamicsHelper.INSTANCE.getGasIngredient(in, amount, temperature, pressure)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            gasIngs.add(ing);
        }
        ItemStack itemStack = null;
        ArrayList<ProbableItem> itemByproducts = new ArrayList<ProbableItem>();
        i = 0;
        while (i < this.itemOutput.length) {
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            ItemStack stack = MiscHelper.INSTANCE.getItemStack(out, count);
            if (itemStack == null) {
                itemStack = stack;
                continue;
            }
            if (stack.isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            itemByproducts.add(new ProbableItem(stack, (double)chance.floatValue()));
        }
        if (itemStack == null) {
            itemStack = ItemStack.EMPTY;
        }
        FluidStack fluidStack = null;
        ArrayList<ProbableFluid> fluidByproducts = new ArrayList<ProbableFluid>();
        i = 0;
        while (i < this.fluidOutput.length) {
            Object out = this.fluidOutput[i];
            Integer amount = 1000;
            if (++i < this.fluidOutput.length && this.fluidOutput[i] instanceof Integer) {
                amount = (Integer)this.fluidOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.fluidOutput.length && this.fluidOutput[i] instanceof Float) {
                chance = (Float)this.fluidOutput[i];
                ++i;
            }
            FluidStack stack = MiscHelper.INSTANCE.getFluidStack(out, amount);
            if (fluidStack == null) {
                fluidStack = stack;
                continue;
            }
            if (stack.isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            fluidByproducts.add(new ProbableFluid(stack, (double)chance.floatValue()));
        }
        if (fluidStack == null) {
            fluidStack = FluidStack.EMPTY;
        }
        GasStack gasStack = null;
        ArrayList<ProbableGas> gasByproducts = new ArrayList<ProbableGas>();
        i = 0;
        while (i < this.gasOutput.length) {
            Object out = this.gasOutput[i];
            Integer amount = 1000;
            if (++i < this.gasOutput.length && this.gasOutput[i] instanceof Integer) {
                amount = (Integer)this.gasOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.gasOutput.length && this.gasOutput[i] instanceof Float) {
                chance = (Float)this.gasOutput[i];
                ++i;
            }
            Integer temperature = 293;
            if (i < this.gasOutput.length && this.gasOutput[i] instanceof Integer) {
                temperature = (Integer)this.gasOutput[i];
                ++i;
            }
            Integer pressure = 1;
            if (i < this.gasOutput.length && this.gasOutput[i] instanceof Integer) {
                pressure = (Integer)this.gasOutput[i];
                ++i;
            }
            GasStack stack = ElectrodynamicsHelper.INSTANCE.getGasStack(out, amount, temperature, pressure);
            if (gasStack == null) {
                gasStack = stack;
                continue;
            }
            if (stack.isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            gasByproducts.add(new ProbableGas(stack, (double)chance.floatValue()));
        }
        if (gasStack == null) {
            gasStack = GasStack.EMPTY;
        }
        if (itemStack.isEmpty() && fluidStack.isEmpty() && gasStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.itemOutput) + ", " + Arrays.deepToString(this.fluidOutput) + ", " + Arrays.deepToString(this.gasOutput));
        }
        ChemicalReactorRecipe recipe = new ChemicalReactorRecipe(this.group, itemIngs, fluidIngs, gasIngs, itemStack, fluidStack, gasStack, this.experience, this.time, this.energy, itemByproducts, fluidByproducts, gasByproducts);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

