/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import electrodynamics.common.recipe.categories.fluiditem2fluid.specificmachines.MineralWasherRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;

public class MineralWasherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputAmount;
    public final double experience;
    public final int time;
    public final double energy;

    public MineralWasherRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        this(key, "", itemInput, itemInputCount, fluidInput, fluidInputAmount, output, outputAmount, experience, time, energy);
    }

    public MineralWasherRecipeSerializer(ResourceLocation key, String group, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        CountableIngredient itemIng = ElectrodynamicsHelper.INSTANCE.getCountableIngredient(this.itemInput, this.itemInputCount);
        if (itemIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.itemInput));
        }
        FluidIngredient fluidIng = ElectrodynamicsHelper.INSTANCE.getFluidIngredient(this.fluidInput, this.fluidInputAmount);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.fluidInput));
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        MineralWasherRecipe recipe = new MineralWasherRecipe(this.group, List.of(itemIng), List.of(fluidIng), stack, this.experience, this.time, this.energy, List.of(), List.of(), List.of());
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

