/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"enderio_machines@[7.0.7,)"})
public class EnderIOModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "enderio";
    }

    @Override
    public void onMaterialConfigAvailable(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        EnderIOHelper helper = EnderIOHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("enderio.byproduct", "minecraft:cobblestone", s -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)s)), "The default byproduct material to output in Ender IO's sagmill.");
            Item byproduct = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)configByproduct));
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerSagMillingRecipe(miscHelper.getRecipeKey("enderio.ore_to_raw_material", material.getName()), oreLocation, 2400, "multiply_output", rawMaterialLocation, 1, Float.valueOf(1.0f), rawMaterialLocation, 1, Float.valueOf(0.33f), byproduct, 1, Float.valueOf(0.15f));
                Object[] output = new Object[]{dustLocation, 1, Float.valueOf(1.0f), dustLocation, 1, Float.valueOf(0.25f)};
                if (material.hasExtra(1)) {
                    ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustLocation, 1, Float.valueOf(0.1f)});
                }
                helper.registerSagMillingRecipe(miscHelper.getRecipeKey("enderio.raw_material_to_dust", material.getName()), rawMaterialLocation, 2400, "multiply_output", output);
                continue;
            }
            Object[] output = new Object[]{dustLocation, 2, Float.valueOf(1.0f), byproduct, 1, Float.valueOf(0.15f)};
            if (material.hasExtra(1)) {
                ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustLocation, 1, Float.valueOf(0.1f)});
            }
            helper.registerSagMillingRecipe(miscHelper.getRecipeKey("enderio.ore_to_dust", material.getName()), oreLocation, 2400, "multiply_output", output);
        }
    }
}

