/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"enderio_machines@[7.0.7,)"})
public class EnderIONonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("coal", "diamond", "emerald", "lapis", "quartz", "redstone"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "enderio_non_ingot";
    }

    @Override
    public void onMaterialConfigAvailable(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        EnderIOHelper helper = EnderIOHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            Object[] objectArray;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("enderio.byproduct", "minecraft:cobblestone", s -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)s)), "The default byproduct material to output in Ender IO's sagmill.");
            Item byproduct = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)configByproduct));
            if (material.getType().isCrystalline()) {
                Object[] objectArray2 = new Object[9];
                objectArray2[0] = materialLocation;
                objectArray2[1] = 2;
                objectArray2[2] = Float.valueOf(1.0f);
                objectArray2[3] = materialLocation;
                objectArray2[4] = 1;
                objectArray2[5] = Float.valueOf(0.5f);
                objectArray2[6] = byproduct;
                objectArray2[7] = 1;
                objectArray = objectArray2;
                objectArray2[8] = Float.valueOf(0.15f);
            } else {
                Object[] objectArray3 = new Object[6];
                objectArray3[0] = materialLocation;
                objectArray3[1] = 4;
                objectArray3[2] = Float.valueOf(1.0f);
                objectArray3[3] = byproduct;
                objectArray3[4] = 1;
                objectArray = objectArray3;
                objectArray3[5] = Float.valueOf(0.15f);
            }
            Object[] output = objectArray;
            if (material.hasExtra(1)) {
                ResourceLocation extraDustLocation = miscHelper.getTagLocation("dust", material.getExtra(1).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustLocation, 1, Float.valueOf(0.1f)});
            }
            helper.registerSagMillingRecipe(miscHelper.getRecipeKey("enderio.ore_to_material", material.getName()), oreLocation, 2400, "multiply_output", output);
        }
    }
}

